/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;

public class TextUtil {
    public static String formatLong(long value) {
        NumberFormat formatter = NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT);
        formatter.setMinimumFractionDigits(1);
        return formatter.format(value);
    }

    public static String formatSeconds(double value, String prefix) {
        DecimalFormat formatter = new DecimalFormat();
        StringBuffer sb = new StringBuffer();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (value >= 3600.0) {
            double hours = value / 3600.0;
            formatter.setMaximumFractionDigits(1);
            formatter.format(hours, sb, new FieldPosition(0));
            sb.append("hr");
            if (hours > 1.9) {
                sb.append("s");
            }
        } else if (value >= 60.0) {
            double minutes = value / 60.0;
            formatter.setMaximumFractionDigits(1);
            formatter.format(minutes, sb, new FieldPosition(0));
            sb.append("min");
            if (minutes > 1.0) {
                sb.append("s");
            }
        } else if (value >= 1.0) {
            double seconds = value;
            formatter.setMaximumFractionDigits(1);
            formatter.format(seconds, sb, new FieldPosition(0));
            sb.append("sec");
            if (seconds > 1.0) {
                sb.append("s");
            }
        } else {
            if (value == 0.0) {
                formatter.setMaximumFractionDigits(1);
                formatter.format(value, sb, new FieldPosition(0));
                sb.append("sec");
                return sb.toString();
            }
            if (value >= 0.001) {
                double ms = value * 1000.0;
                formatter.setMaximumFractionDigits(1);
                formatter.format(ms, sb, new FieldPosition(0));
                sb.append("ms");
            } else if (value >= 1.0E-6) {
                double us = value * 1000000.0;
                formatter.setMaximumFractionDigits(1);
                formatter.format(us, sb, new FieldPosition(0));
                sb.append("\u00b5s");
            } else if (value >= 1.0E-9) {
                double ns = value * 1.0E9;
                formatter.setMaximumFractionDigits(1);
                formatter.format(ns, sb, new FieldPosition(0));
                sb.append("ns");
            } else {
                sb.append("--");
            }
        }
        return sb.toString();
    }

    public static String formatNumber(double value, String prefix) {
        DecimalFormat formatter = new DecimalFormat();
        StringBuffer sb = new StringBuffer();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (value >= 1.0E12) {
            double terra = value / 1.0E12;
            formatter.setMaximumFractionDigits(1);
            formatter.format(terra, sb, new FieldPosition(0));
            sb.append("T");
        } else if (value >= 1.0E9) {
            double giga = value / 1.0E9;
            formatter.setMaximumFractionDigits(1);
            formatter.format(giga, sb, new FieldPosition(0));
            sb.append("G");
        } else if (value >= 1000000.0) {
            double giga = value / 1000000.0;
            formatter.setMaximumFractionDigits(1);
            formatter.format(giga, sb, new FieldPosition(0));
            sb.append("M");
        } else if (value >= 1000.0) {
            double kilo = value / 1000.0;
            formatter.setMaximumFractionDigits(1);
            formatter.format(kilo, sb, new FieldPosition(0));
            sb.append("K");
        } else if (value >= 1.0) {
            double units = value;
            formatter.setMaximumFractionDigits(1);
            formatter.format(units, sb, new FieldPosition(0));
        } else if (value == 0.0) {
            double units = value;
            sb.append("0");
        } else if (value >= 0.001) {
            double milli = value * 1000.0;
            formatter.setMaximumFractionDigits(1);
            formatter.format(milli, sb, new FieldPosition(0));
        } else {
            sb.append("--");
        }
        return sb.toString();
    }

    public static String formatSize(long size) {
        if (size <= 0L) {
            return "0 B";
        }
        String[] units = new String[]{"", "K", "M", "G", "T"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return String.format("%.1f%s", (double)size / Math.pow(1024.0, digitGroups), units[digitGroups]);
    }

    public static String format(long value) {
        NumberFormat f = NumberFormat.getIntegerInstance();
        return f.format(value);
    }
}

