/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.sodacan.core.util.PoolItemFactory;

public class Pool<T> {
    private final BlockingQueue<T> pool;

    public Pool(int maxSize, PoolItemFactory<T> factory) {
        this.pool = new LinkedBlockingQueue<T>(maxSize);
        for (int i = 0; i < maxSize; ++i) {
            try {
                this.pool.put(factory.createItem());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public T acquireItem() throws InterruptedException {
        return this.pool.take();
    }

    public void returnItem(T obj) throws InterruptedException {
        this.pool.put(obj);
    }
}

