/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.sodacan.core.Actor;
import net.sodacan.core.annotation.ActorType;

public class ClassUtilities {
    private static Class<? extends Actor> getClass(String className, String packageName) {
        try {
            Class<?> clazz = Class.forName(packageName + "." + className.substring(0, className.lastIndexOf(46)));
            if (Actor.class.isAssignableFrom(clazz) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static Map<String, Class<? extends Actor>> getActorClassesFromPackage(String packageName, Map<String, Class<? extends Actor>> actorClasses) throws Exception {
        String line;
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            boolean isActorType;
            if (!line.endsWith(".class")) continue;
            String className = packageName + "." + line.substring(0, line.lastIndexOf(46));
            Class<?> clazz = Class.forName(className);
            if (clazz == null) {
                System.out.println("Problem finding class: " + className);
                continue;
            }
            boolean isActor = Actor.class.isAssignableFrom(clazz);
            Class<?> actorClass = clazz;
            ActorType ata = clazz.getAnnotation(ActorType.class);
            boolean bl = isActorType = ata != null && ata instanceof ActorType;
            if (!isActor && !isActorType) continue;
            boolean isAbstract = Modifier.isAbstract(actorClass.getModifiers());
            if (isActorType && isActor && !isAbstract) {
                String actorTypeName = ata.name();
                if (actorTypeName == null) {
                    actorTypeName = actorClass.getSimpleName();
                }
                if (actorClasses.containsKey(actorTypeName)) {
                    throw new RuntimeException("Duplicate actorType: " + actorTypeName);
                }
                actorClasses.put(actorTypeName, actorClass);
                continue;
            }
            if (isActor || !isActorType) continue;
            throw new RuntimeException("@ActorType not allowed on: " + clazz.getName());
        }
        System.out.println(actorClasses);
        return actorClasses;
    }
}

