/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sodacan.core.util.BBAlloc;

public class BBBTree {
    public static final int INITIAL_NODE_ALLOCATION = 500;
    private BBAlloc a;
    private Set<Node> changedNodes = new HashSet<Node>();
    private Node root = null;
    private Map<Integer, Node> nodesByRef = new HashMap<Integer, Node>();

    public BBBTree(BBAlloc a) {
        this.a = a;
    }

    public void store(Integer ref, String serialized) {
        this.a.store(ref, serialized);
    }

    public Integer store(String serialized) {
        return this.a.store(serialized);
    }

    public String getNodeString(Integer ref) {
        return this.a.fetch(ref);
    }

    public void commit() {
        for (Node node : this.changedNodes) {
            node.assignReference();
        }
        for (Node node : this.changedNodes) {
            node.saveNode();
        }
        this.changedNodes.clear();
    }

    public BBAlloc getAlloc() {
        return this.a;
    }

    public Set<Node> getChangedNodes() {
        return this.changedNodes;
    }

    public Node getRoot() {
        if (this.root != null) {
            return this.root;
        }
        if (this.a.count() == 0) {
            this.a.store("A place to store root ref");
            this.root = new Node(this);
        } else {
            String rootString = this.a.fetch(0);
            Integer ref = Integer.valueOf(rootString);
            this.root = new Node(this, ref);
        }
        return this.root;
    }

    public void setRoot(Node root) {
        this.root = root;
    }

    public static class Node {
        boolean realized;
        Integer ref;
        BBBTree tree;
        String name;
        Node parent;
        List<Node> children;

        public Node(BBBTree tree) {
            this.realized = true;
            this.tree = tree;
            this.name = null;
            this.ref = null;
            this.children = new LinkedList<Node>();
            this.tree.changedNodes.add(this);
        }

        public Node(BBBTree tree, Node parent) {
            this(tree);
            this.parent = parent;
            parent.addChild(this);
        }

        public Node(BBBTree tree, Integer ref) {
            this.realized = false;
            this.tree = tree;
            this.ref = ref;
            tree.nodesByRef.put(ref, this);
            this.children = new LinkedList<Node>();
        }

        public void setName(String name) {
            this.realize();
            this.name = name;
            this.tree.changedNodes.add(this);
        }

        public void addChild(Node child) {
            this.realize();
            this.children.add(child);
            this.tree.changedNodes.add(this);
        }

        public void realize() {
            if (this.realized) {
                return;
            }
            if (this.ref == null) {
                throw new RuntimeException("Missing ref for realization");
            }
            String nodeString = this.tree.getNodeString(this.ref);
            String[] f = nodeString.split("\\|");
            this.name = f[0];
            if (f[1] != null && !f[1].isEmpty()) {
                int parentRef = Integer.parseInt(f[1]);
                this.parent = this.tree.nodesByRef.get(parentRef);
                if (this.parent == null) {
                    this.parent = new Node(this.tree, parentRef);
                }
            }
            for (int x = 2; x < f.length; ++x) {
                int childRef = Integer.parseInt(f[x]);
                Node child = this.tree.nodesByRef.get(childRef);
                if (child == null) {
                    child = new Node(this.tree, childRef);
                }
                this.children.add(child);
            }
            this.realized = true;
        }

        public void assignReference() {
            if (this.ref == null) {
                this.ref = this.tree.getAlloc().alloc(0);
            }
            this.tree.nodesByRef.put(this.ref, this);
        }

        public void saveNode() {
            this.realize();
            StringBuffer sb = new StringBuffer();
            sb.append(this.name);
            sb.append('|');
            if (this.parent != null) {
                sb.append(this.parent.ref);
            }
            for (Node child : this.children) {
                sb.append('|');
                sb.append(child.ref.toString());
            }
            this.tree.store(this.ref, sb.toString());
            if (this.parent == null) {
                this.tree.store(0, Integer.toString(this.ref));
            }
        }

        public Integer getRef() {
            return this.ref;
        }

        public String getName() {
            this.realize();
            return this.name;
        }

        public Node getParent() {
            this.realize();
            return this.parent;
        }

        public List<Node> getChildren() {
            this.realize();
            return this.children;
        }

        public String toString() {
            return "(" + this.ref + ") " + this.name;
        }
    }
}

