/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BBAlloc
implements Closeable {
    public static final int HEADER_SIZE = 1024;
    public static final int INT_SIZE = 4;
    public static final int MAGIC_NUMBER = 3275;
    int version = 1;
    int magicNumber;
    int refMax;
    int spaceMax;
    int refBase;
    int freeSpaceBase;
    int nextRef;
    int nextFreeSpace;
    int wastedSpace = 0;
    ByteBuffer space;

    public BBAlloc(ByteBuffer space) {
        this.space = space;
        this.restoreHeader();
    }

    public BBAlloc(ByteBuffer space, int refMax, int spaceMax) {
        this.space = space;
        if (3275 == space.getInt()) {
            this.restoreHeader();
            this.spaceMax = spaceMax;
        } else {
            this.magicNumber = 3275;
            this.spaceMax = spaceMax;
            this.refBase = 1024;
            this.nextRef = 0;
            this.refMax = refMax;
            this.nextFreeSpace = this.freeSpaceBase = this.refBase + refMax * 4;
            this.saveHeader();
        }
    }

    public BBAlloc(BBAlloc src, ByteBuffer space, int refMax, int spaceMax) {
        this.version = 1;
        this.spaceMax = spaceMax;
        this.space = space;
        this.refBase = 1024;
        this.nextRef = 0;
        this.refMax = refMax;
        this.nextFreeSpace = this.freeSpaceBase = this.refBase + refMax * 4;
        this.saveHeader();
        for (int x = 0; x < src.count(); ++x) {
            this.store(src.fetch(x));
        }
    }

    private void restoreHeader() {
        this.space.rewind();
        this.magicNumber = this.space.getInt();
        this.version = this.space.getInt();
        this.spaceMax = this.space.getInt();
        this.refMax = this.space.getInt();
        this.refBase = this.space.getInt();
        this.freeSpaceBase = this.space.getInt();
        this.nextRef = this.space.getInt();
        this.nextFreeSpace = this.space.getInt();
        this.wastedSpace = this.space.getInt();
    }

    public void saveHeader() {
        this.space.rewind();
        this.space.putInt(this.magicNumber);
        this.space.putInt(this.version);
        this.space.putInt(this.spaceMax);
        this.space.putInt(this.refMax);
        this.space.putInt(this.refBase);
        this.space.putInt(this.freeSpaceBase);
        this.space.putInt(this.nextRef);
        this.space.putInt(this.nextFreeSpace);
        this.space.putInt(this.wastedSpace);
    }

    public void setPointerAddress(int ref, int offset) {
        int p = this.refBase + ref * 4;
        this.space.putInt(p, offset);
    }

    public int alloc(int size) {
        if (this.nextRef >= this.refMax) {
            throw new RuntimeException("No room for another reference to be added");
        }
        if (this.nextFreeSpace + size >= this.spaceMax) {
            throw new RuntimeException("No room for allocation size=" + size);
        }
        if (size < 0) {
            throw new RuntimeException("Allocation size must be zero or greater");
        }
        int p = this.refBase + this.nextRef * 4;
        if (size == 0) {
            this.space.putInt(p, 0);
        } else {
            int base = this.nextFreeSpace;
            this.space.putInt(p, base);
            this.space.putInt(base, size);
            this.nextFreeSpace += size + 4;
        }
        int ref = this.nextRef++;
        return ref;
    }

    public int getAddress(int ref) {
        if (ref < 0 || ref >= this.nextRef) {
            throw new RuntimeException("reference is out of range");
        }
        int p = this.refBase + ref * 4;
        return this.space.getInt(p) + 4;
    }

    public int getSize(int ref) {
        if (ref < 0 || ref >= this.nextRef) {
            throw new RuntimeException("reference is out of range");
        }
        int p = this.refBase + ref * 4;
        int base = this.space.getInt(p);
        if (base == 0) {
            return 0;
        }
        return this.space.getInt(base);
    }

    public int store(String src) {
        byte[] srcBytes = src.getBytes();
        int size = srcBytes.length;
        int ref = this.alloc(size);
        int dest = this.getAddress(ref);
        this.space.put(dest, srcBytes);
        return ref;
    }

    public void store(Integer ref, String src) {
        byte[] srcBytes = src.getBytes();
        if (this.getSize(ref) == 0) {
            this.setPointerAddress(ref, this.nextFreeSpace);
            this.space.putInt(this.nextFreeSpace, srcBytes.length);
            this.space.put(this.nextFreeSpace + 4, srcBytes);
            this.nextFreeSpace += srcBytes.length + 4;
        } else {
            this.replace(ref, src);
        }
    }

    protected void replace(int ref, String src) {
        if (ref < 0 || ref >= this.nextRef) {
            throw new RuntimeException("reference is out of range");
        }
        byte[] srcBytes = src.getBytes();
        if (this.getSize(ref) > srcBytes.length) {
            int offset = this.getAddress(ref);
            this.space.put(offset, srcBytes);
            this.space.putInt(offset - 4, srcBytes.length);
        } else {
            this.wastedSpace += this.getSize(ref);
            this.setPointerAddress(ref, this.nextFreeSpace);
            this.space.putInt(this.nextFreeSpace, srcBytes.length);
            this.space.put(this.nextFreeSpace + 4, srcBytes);
            this.nextFreeSpace += srcBytes.length + 4;
        }
    }

    public int count() {
        return this.nextRef;
    }

    public String fetch(int ref) {
        if (ref < 0 || ref >= this.nextRef) {
            throw new RuntimeException("reference is out of range");
        }
        int src = this.getAddress(ref);
        int size = this.getSize(ref);
        byte[] bytes = new byte[size];
        this.space.get(src, bytes);
        return new String(bytes);
    }

    public int getWastedSpace() {
        return this.wastedSpace;
    }

    public int getSpaceUsed() {
        return this.nextFreeSpace;
    }

    @Override
    public void close() throws IOException {
        this.saveHeader();
    }
}

