/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Message;
import net.sodacan.core.Route;
import net.sodacan.core.Serializer;
import net.sodacan.core.config.ActorMetadata;
import net.sodacan.core.serialize.SerializerFactory;
import net.sodacan.core.serialize.kryo.KryoSerializer;
import net.sodacan.core.util.Pool;
import net.sodacan.core.util.PoolItemFactory;

public class KryoSerializerFactory
implements SerializerFactory,
PoolItemFactory<Kryo> {
    private Config config;
    protected Class<? extends Message> messageClass;
    protected Pool<Kryo> pool;

    public KryoSerializerFactory(Config config) {
        this.config = config;
        this.messageClass = config.createMessage().getClass();
        this.pool = new Pool<Kryo>(10, this);
    }

    @Override
    public Kryo createItem() {
        Message m99 = this.config.createMessage();
        Kryo kryo = new Kryo();
        kryo.register(Instant.class, 101);
        kryo.register(HashMap.class, 102);
        kryo.register(LinkedList.class, 103);
        kryo.register(ActorId.class, 202);
        kryo.register(m99.getClass(), 205);
        kryo.register(m99.getMessageId().getClass(), 206);
        kryo.register(Route.class, 207);
        int appBase = 300;
        return kryo;
    }

    @Override
    public Serializer create(ActorId actorId) {
        String actorType = actorId.getType();
        ActorMetadata actorMetadata = this.config.getActorMetadata(actorType);
        KryoSerializer serializer = new KryoSerializer(this, actorId, actorMetadata);
        return serializer;
    }

    public Config getConfig() {
        return this.config;
    }

    public Class<? extends Message> getMessageClass() {
        return this.messageClass;
    }
}

