/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.sodacan.core.Actor;
import net.sodacan.core.ActorId;
import net.sodacan.core.Message;
import net.sodacan.core.Serializer;
import net.sodacan.core.config.ActorMetadata;
import net.sodacan.core.serialize.kryo.KryoSerializerFactory;

public class KryoSerializer
implements Serializer {
    protected KryoSerializerFactory factory;
    protected ActorMetadata actorMetadata;
    protected ActorId actorId;

    public KryoSerializer(KryoSerializerFactory factory, ActorId actorId, ActorMetadata actorMetadata) {
        this.factory = factory;
        this.actorMetadata = actorMetadata;
        this.actorId = actorId;
    }

    @Override
    public byte[] serialize(Actor actor) {
        Kryo kryo = null;
        try {
            kryo = this.factory.pool.acquireItem();
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            for (Map.Entry<String, Field> entry : this.actorMetadata.getSaveFields().entrySet()) {
                Object value = entry.getValue().get(actor);
                if (value == null) continue;
                fieldValues.put(entry.getKey(), value);
            }
            ActorSave as = new ActorSave(actor.getActorId(), fieldValues);
            ByteBuffer bb = ByteBuffer.allocate(100);
            ByteBufferOutput output = new ByteBufferOutput(bb);
            kryo.writeObject((Output)output, (Object)as);
            byte[] byArray = output.toBytes();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Error Serializing actor " + actor.getActorId().toString(), e);
        }
        finally {
            try {
                this.factory.pool.returnItem(kryo);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void deserialize(byte[] source, Actor actor) {
        String actorType = actor.getActorId().getType();
        Kryo kryo = null;
        try {
            kryo = this.factory.pool.acquireItem();
            Input input = new Input(source);
            ActorSave as = (ActorSave)kryo.readObject(input, ActorSave.class);
            for (Map.Entry<String, Field> entry : this.factory.getConfig().getActorMetadata(actorType).getSaveFields().entrySet()) {
                Field field = entry.getValue();
                Object value = as.fields.get(entry.getKey());
                field.set(actor, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error Deserializing actor " + actor.getActorId().toString(), e);
        }
        finally {
            try {
                this.factory.pool.returnItem(kryo);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public byte[] serialize(Message message) {
        Kryo kryo = null;
        try {
            kryo = this.factory.pool.acquireItem();
            ByteBuffer bb = ByteBuffer.allocate(100);
            ByteBufferOutput output = new ByteBufferOutput(bb);
            kryo.writeObject((Output)output, (Object)message);
            byte[] byArray = output.toBytes();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Error Serializing message ", e);
        }
        finally {
            try {
                this.factory.pool.returnItem(kryo);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Message deserialize(byte[] source) {
        Kryo kryo = null;
        try {
            Message m;
            kryo = this.factory.pool.acquireItem();
            Input input = new Input(source);
            Message message = m = (Message)kryo.readObject(new Input(source), this.factory.getMessageClass());
            return message;
        }
        catch (Exception e) {
            throw new RuntimeException("Error Deserializing message", e);
        }
        finally {
            try {
                this.factory.pool.returnItem(kryo);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static class ActorSave {
        ActorId actorId;
        Map<String, Object> fields;

        public ActorSave(ActorId actorId, Map<String, Object> fieldValues) {
            this.actorId = actorId;
            this.fields = fieldValues;
        }

        public ActorId getActorId() {
            return this.actorId;
        }

        public Map<String, Object> getFieldValues() {
            return this.fields;
        }
    }
}

