/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.serialize.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import net.sodacan.core.ActorId;
import net.sodacan.core.Route;
import net.sodacan.core.Verb;

public class RouteAdapter
implements JsonSerializer<Route>,
JsonDeserializer<Route> {
    public JsonElement serialize(Route route, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        JsonObject top = new JsonObject();
        top.addProperty("target", route.getTarget().toString());
        top.addProperty("verb", route.getVerb().toString());
        top.addProperty("verbType", route.getVerb().getClass().getName());
        obj.add("route", (JsonElement)top);
        return obj;
    }

    public Route deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject root = json.getAsJsonObject();
        JsonObject route = root.get("route").getAsJsonObject();
        JsonElement target = route.get("target");
        JsonElement verb = route.get("verb");
        JsonElement verbType = route.get("verbType");
        Class<?> c = null;
        try {
            this.getClass();
            c = Class.forName(verbType.getAsString());
            Field verbField = c.getField(verb.getAsString());
            Verb v = (Verb)verbField.get(null);
            ActorId actorId = ActorId.createFromString(target.getAsString());
            Route finishedRoute = new Route();
            finishedRoute.setTarget(actorId);
            finishedRoute.setVerb(v);
            return finishedRoute;
        }
        catch (Exception e) {
            throw new RuntimeException("Error deserializing route", e);
        }
    }
}

