/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.serialize.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Map;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Message;
import net.sodacan.core.MessageId;
import net.sodacan.core.Route;
import net.sodacan.core.Serializer;
import net.sodacan.core.config.ActorMetadata;
import net.sodacan.core.serialize.SerializerFactory;
import net.sodacan.core.serialize.gson.ActorIdAdapter;
import net.sodacan.core.serialize.gson.GsonSerializer;
import net.sodacan.core.serialize.gson.InstantTypeAdapter;
import net.sodacan.core.serialize.gson.MapAdapter;
import net.sodacan.core.serialize.gson.MessageIdAdapter;
import net.sodacan.core.serialize.gson.RouteAdapter;
import net.sodacan.core.util.Pool;
import net.sodacan.core.util.PoolItemFactory;

public class GsonSerializerFactory
implements SerializerFactory,
PoolItemFactory<Gson> {
    private Config config;
    protected Class<? extends Message> messageClass;
    protected GsonBuilder builder;
    protected Pool<Gson> pool;

    public GsonSerializerFactory(Config config) {
        this.config = config;
        this.messageClass = config.createMessage().getClass();
        this.pool = new Pool<Gson>(10, this);
    }

    public GsonBuilder getBuilderFor(ActorId actorId) {
        return this.builder;
    }

    @Override
    public Gson createItem() {
        Type mapType = new TypeToken<Map<String, Object>>(this){}.getType();
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Instant.class, (Object)new InstantTypeAdapter()).registerTypeAdapter(MessageId.class, (Object)new MessageIdAdapter()).registerTypeAdapter(Route.class, (Object)new RouteAdapter()).registerTypeAdapter(ActorId.class, (Object)new ActorIdAdapter()).registerTypeAdapter(mapType, (Object)new MapAdapter()).create();
    }

    @Override
    public Serializer create(ActorId actorId) {
        String actorType = actorId.getType();
        ActorMetadata actorMetadata = this.config.getActorMetadata(actorType);
        GsonSerializer serializer = new GsonSerializer(this, actorId, actorMetadata);
        return serializer;
    }

    public Config getConfig() {
        return this.config;
    }

    public Class<? extends Message> getMessageClass() {
        return this.messageClass;
    }
}

