/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.serialize.gson;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.sodacan.core.Actor;
import net.sodacan.core.ActorId;
import net.sodacan.core.Message;
import net.sodacan.core.Serializer;
import net.sodacan.core.config.ActorMetadata;
import net.sodacan.core.serialize.gson.GsonSerializerFactory;

public class GsonSerializer
implements Serializer {
    protected GsonSerializerFactory factory;
    protected ActorMetadata actorMetadata;
    protected ActorId actorId;

    public GsonSerializer(GsonSerializerFactory factory, ActorId actorId, ActorMetadata actorMetadata) {
        this.factory = factory;
        this.actorMetadata = actorMetadata;
        this.actorId = actorId;
    }

    @Override
    public byte[] serialize(Actor actor) {
        if (this.actorMetadata.getSaveFields().isEmpty()) {
            return null;
        }
        Gson gson = null;
        try {
            gson = this.factory.pool.acquireItem();
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            for (Map.Entry<String, Field> entry : this.actorMetadata.getSaveFields().entrySet()) {
                Object value = entry.getValue().get(actor);
                if (value == null) continue;
                fieldValues.put(entry.getKey(), value);
            }
            ActorSave as = new ActorSave(actor.getActorId(), fieldValues);
            String json = gson.toJson((Object)as);
            byte[] byArray = json.getBytes();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Error Serializing actor " + actor.getActorId().toString(), e);
        }
        finally {
            try {
                this.factory.pool.returnItem(gson);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void deserialize(byte[] source, Actor actor) {
        Gson gson = null;
        String actorType = actor.getActorId().getType();
        try {
            gson = this.factory.pool.acquireItem();
            ActorSave as = (ActorSave)gson.fromJson(new String(source), ActorSave.class);
            for (Map.Entry<String, Field> entry : this.factory.getConfig().getActorMetadata(actorType).getSaveFields().entrySet()) {
                Field field = entry.getValue();
                Object value = as.fields.get(entry.getKey());
                field.set(actor, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error Deserializing actor " + actor.getActorId().toString(), e);
        }
        finally {
            try {
                this.factory.pool.returnItem(gson);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(Message message) {
        Gson gson = null;
        try {
            gson = this.factory.pool.acquireItem();
            String json = gson.toJson((Object)message);
            byte[] byArray = json.getBytes();
            return byArray;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.factory.pool.returnItem(gson);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message deserialize(byte[] source) {
        Gson gson = null;
        try {
            gson = this.factory.pool.acquireItem();
            Message message = (Message)gson.fromJson(new String(source), this.factory.getMessageClass());
            return message;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.factory.pool.returnItem(gson);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    public static class ActorSave {
        ActorId actorId;
        Map<String, Object> fields;

        public ActorSave(ActorId actorId, Map<String, Object> fieldValues) {
            this.actorId = actorId;
            this.fields = fieldValues;
        }

        public ActorId getActorId() {
            return this.actorId;
        }

        public Map<String, Object> getFieldValues() {
            return this.fields;
        }
    }
}

