/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.scheduler;

import java.io.Closeable;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Jug;
import net.sodacan.core.Scheduler;
import net.sodacan.core.actor.ActorEntry;
import net.sodacan.core.jug.AuditMessageLoad;
import net.sodacan.core.jug.CloseHostBoundActor;
import net.sodacan.core.jug.ErrorMessage;
import net.sodacan.core.jug.NormalMessage;
import net.sodacan.core.jug.StoppedActor;
import net.sodacan.core.scheduler.Statistics;

public class DefaultScheduler
extends Thread
implements Scheduler,
Closeable {
    private Config config;
    protected ActorGroup actorGroup;
    private Statistics stats;
    private ThreadPoolExecutor pool;
    private BlockingQueue<Jug> messageQueue = null;
    private Map<ActorId, ActorEntry> actorEntries = new HashMap<ActorId, ActorEntry>();

    public DefaultScheduler(Config config, ActorGroup actorGroup) {
        this.config = config;
        this.actorGroup = actorGroup;
        int tpSize = config.getActorGroupThreads();
        this.pool = tpSize > 1 ? (ThreadPoolExecutor)Executors.newFixedThreadPool(tpSize) : (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.messageQueue = new ArrayBlockingQueue<Jug>(config.getBackpressureLimit() * 2);
        this.stats = new Statistics(actorGroup);
    }

    @Override
    public Statistics getStatistics() {
        return this.stats;
    }

    @Override
    public ActorGroup getActorGroup() {
        return this.actorGroup;
    }

    @Override
    public void addMessage(Jug jug) {
        this.messageQueue.add(jug);
        if (this.stats.running.compareAndSet(false, true)) {
            this.start();
        }
        this.increaseMessageLoad();
    }

    @Override
    public void addNewMessage(Jug jug) {
        this.applyBackpressure();
        if (this.stats.closing.get()) {
            throw new RuntimeException("ActorGroup " + String.valueOf(this.getActorGroup()) + " is closing down, no new messages");
        }
        this.addMessage(jug);
    }

    protected void applyBackpressure() {
        while (this.stats.getMessageLoad() > this.config.getBackpressureLimit()) {
            try {
                this.incrementSleepTime();
                Thread.sleep(this.config.getBackpressureWaitMs());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void run() {
        block9: while (!this.isInterrupted()) {
            Jug jug;
            Jug jug2 = null;
            try {
                jug2 = this.messageQueue.take();
            }
            catch (InterruptedException e) {
                break;
            }
            Objects.requireNonNull(jug2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuditMessageLoad.class, StoppedActor.class, ErrorMessage.class, NormalMessage.class, CloseHostBoundActor.class}, (Object)jug, n)) {
                case 0: {
                    AuditMessageLoad aml = (AuditMessageLoad)jug;
                    this.auditMessageLoad(aml);
                    continue block9;
                }
                case 1: {
                    StoppedActor sa = (StoppedActor)jug;
                    this.stoppedActor(sa);
                    continue block9;
                }
                case 2: {
                    ErrorMessage em = (ErrorMessage)jug;
                    this.errorMessage(em);
                    continue block9;
                }
                case 3: {
                    NormalMessage nm = (NormalMessage)jug;
                    this.normalMessage(nm);
                    continue block9;
                }
                case 4: {
                    CloseHostBoundActor chba = (CloseHostBoundActor)jug;
                    this.closeHostBoundActor(chba);
                    continue block9;
                }
            }
            throw new RuntimeException("Invalid message received");
        }
    }

    protected void normalMessage(NormalMessage nm) {
        this.increaseMessageCount();
        ActorId actorId = nm.getActorId();
        ActorEntry actorEntry = this.actorEntries.get(actorId);
        if (actorEntry == null) {
            actorEntry = new ActorEntry(this.config, this, actorId);
            this.actorEntries.put(actorId, actorEntry);
        }
        actorEntry.queueMessage(nm);
        actorEntry.startThread(this.pool);
    }

    public void auditMessageLoad(AuditMessageLoad aml) {
        for (ActorEntry ae : this.actorEntries.values()) {
            int size = ae.getQueueSize();
            if (size <= 0) continue;
            ae.startThread(this.pool);
        }
        this.decreaseMessageLoad();
    }

    public void errorMessage(ErrorMessage em) {
        System.err.println("Error from Actor " + String.valueOf(em.getActorId()));
        System.err.println(em.getException());
        this.decreaseMessageLoad();
    }

    public void closeHostBoundActor(CloseHostBoundActor chba) {
        this.increaseMessageCount();
        ActorId actorId = chba.getActorId();
        ActorEntry actorEntry = this.actorEntries.get(actorId);
        if (actorEntry == null) {
            actorEntry = new ActorEntry(this.config, this, actorId);
            this.actorEntries.put(actorId, actorEntry);
        }
        actorEntry.queueMessage(chba);
        actorEntry.startThread(this.pool);
    }

    protected boolean evict(ActorEntry ae) {
        if (ae.getActorId().getActorGroup() < 0) {
            return false;
        }
        if (ae.evictionProbability() < 0.5f) {
            return false;
        }
        this.actorEntries.remove(ae.getActorId());
        this.increaseEvictionCount();
        return true;
    }

    protected void stoppedActor(StoppedActor sa) {
        this.decreaseMessageLoad();
        ActorId actorId = sa.getActorId();
        ActorEntry ae = this.actorEntries.get(actorId);
        if (ae == null) {
            return;
        }
        if (ae.getQueueSize() > 0) {
            ae.startThread(this.pool);
        } else if (this.evict(ae)) {
            // empty if block
        }
    }

    protected boolean livelinessCheck() {
        return true;
    }

    @Override
    public void waitForMessagesToFinish() {
        try {
            while (0 != this.stats.getMessageLoad()) {
                if (0 > this.stats.getMessageLoad()) {
                    throw new RuntimeException("Negative messageLoad, something is wrong");
                }
                if (!this.livelinessCheck()) {
                    throw new RuntimeException("No message activity, something is wrong");
                }
                System.out.println("Waiting for " + this.stats.getMessageLoad() + " messages to finish in actorGroup " + this.getActorGroup().getActorGroupNumber());
                this.addNewMessage(new AuditMessageLoad());
                Thread.sleep(this.config.getShutdownWaitMs());
            }
            System.out.println("No more messages to process for actorGroup " + String.valueOf(this.getActorGroup()));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.waitForMessagesToFinish();
            this.stats.closing.set(true);
            this.interrupt();
            this.pool.awaitTermination(1L, TimeUnit.SECONDS);
            this.pool.shutdown();
            for (ActorEntry ae : this.actorEntries.values()) {
                if (ae.getQueueSize() == 0) continue;
                throw new RuntimeException("Non-empty queue in ActorEntry " + String.valueOf(ae));
            }
            this.actorEntries.clear();
            System.out.println("Orderly shutdown complete for actorGroup: " + String.valueOf(this.getActorGroup()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error closing Scheduler for ActorGroup " + String.valueOf(this), e);
        }
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void increaseMessageLoad() {
        int load = this.stats.messageLoad.incrementAndGet();
        if (load > this.stats.maxMessageLoad.get()) {
            this.stats.maxMessageLoad.set(load);
        }
    }

    @Override
    public void decreaseMessageLoad() {
        this.stats.messageLoad.decrementAndGet();
    }

    @Override
    public void incrementSleepTime() {
        this.stats.totalSleepTime.addAndGet(this.getConfig().getBackpressureWaitMs());
    }

    @Override
    public void increaseMessageCount() {
        this.stats.messageCount.incrementAndGet();
    }

    @Override
    public void increaseEvictionCount() {
        this.stats.evictionCount.incrementAndGet();
    }

    @Override
    public void evictAll() {
    }

    @Override
    public String toString() {
        if (this.actorGroup != null) {
            return this.actorGroup.toString();
        }
        return "Standalone Scheduler";
    }

    @Override
    public void incrementActorsCreated() {
        this.stats.totalActorsCreated.incrementAndGet();
    }
}

