/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.persist.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.persist.AbstractPersister;

public class FilePersister
extends AbstractPersister {
    File file = this.makeFile(".dat");

    public FilePersister(Config config, ActorId actorId) {
        super(config, actorId);
    }

    @Override
    public void begin() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public void write(String key, byte[] bytes) {
        try {
            Files.write(this.file.toPath(), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to file: " + this.file.getAbsolutePath(), e);
        }
    }

    @Override
    public byte[] read(String key) {
        try {
            if (this.file.exists()) {
                return Files.readAllBytes(this.file.toPath());
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from file: " + this.file.getAbsolutePath(), e);
        }
    }
}

