/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.persist;

import java.io.File;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Persister;

public abstract class AbstractPersister
implements Persister {
    private Config config;
    private ActorId actorId;

    public AbstractPersister(Config config, ActorId actorId) {
        this.config = config;
        this.actorId = actorId;
    }

    public Config getConfig() {
        return this.config;
    }

    public ActorId getActorId() {
        return this.actorId;
    }

    protected File makeFile(String extension) {
        File typeDir = this.makeTypeFolder();
        File file = new File(typeDir, this.actorId.getId() + extension);
        return file;
    }

    protected File makeFolder() {
        File typeDir = this.makeTypeFolder();
        File folder = new File(typeDir, this.actorId.getId());
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    protected File makeTypeFolder() {
        File typeDir;
        File actorGroupDir;
        String rootDir = this.config.getRootDirectory();
        File root = new File(rootDir);
        File hostDir = new File(root, "H-" + this.config.getHostNumber());
        if (!hostDir.exists()) {
            hostDir.mkdir();
        }
        if (!(actorGroupDir = new File(hostDir, "AG-" + this.actorId.getActorGroup())).exists()) {
            actorGroupDir.mkdir();
        }
        if (!(typeDir = new File(actorGroupDir, this.actorId.getType())).exists()) {
            typeDir.mkdir();
        }
        return typeDir;
    }
}

