/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.message;

import java.time.Instant;
import net.sodacan.core.Config;
import net.sodacan.core.MessageId;

public class DefaultMessageId
implements MessageId,
Comparable<MessageId> {
    protected Instant timestamp;
    protected int unique;

    public DefaultMessageId() {
        this.timestamp = null;
        this.unique = 0;
    }

    public DefaultMessageId(Instant timestamp, int unique) {
        this.timestamp = timestamp;
        this.unique = unique;
    }

    public DefaultMessageId(Config config) {
        this.timestamp = config.getClock().instant();
        this.unique = Math.abs(config.getRandom().nextInt());
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getUnique() {
        return this.unique;
    }

    public String toString() {
        if (this.timestamp != null) {
            return this.timestamp.toString() + "-" + this.unique;
        }
        return "No timestamp";
    }

    public int hashCode() {
        return this.timestamp.hashCode() << 1 + this.unique << 2;
    }

    public boolean equals(Object other) {
        if (other instanceof DefaultMessageId) {
            DefaultMessageId dmi = (DefaultMessageId)other;
            return this.timestamp.equals(dmi.timestamp) && this.unique == dmi.unique;
        }
        return false;
    }

    @Override
    public int compareTo(MessageId o) {
        int r = this.timestamp.compareTo(o.getTimestamp());
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.unique, o.getUnique());
    }
}

