/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.message;

import java.io.PrintStream;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sodacan.core.Actor;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Message;
import net.sodacan.core.MessageId;
import net.sodacan.core.Route;
import net.sodacan.core.Stage;
import net.sodacan.core.Verb;

public class DefaultMessage
implements Message {
    private MessageId messageId;
    private List<Route> history = new LinkedList<Route>();
    private boolean keepHistory = false;
    private Route currentRoute = null;
    private LinkedList<Route> routes = new LinkedList();
    private Route buildRoute = null;
    private Map<String, Object> payload = new HashMap<String, Object>();

    public DefaultMessage() {
    }

    public DefaultMessage(MessageId messageId) {
        this.messageId = messageId;
    }

    public DefaultMessage(Message source) {
        this.messageId = source.getMessageId();
    }

    @Override
    public Message from(Message source) {
        this.messageId = source.getMessageId();
        this.keepHistory = source.isKeepHistory();
        if (this.keepHistory) {
            this.history = source.getHistory();
        }
        this.payload.putAll(source.getPayload());
        return this;
    }

    public boolean validateMessage(Config config) {
        Route route = this.peekRoute();
        if (route == null) {
            throw new RuntimeException("Message has no routes, message not sent");
        }
        ActorId target = route.getTarget();
        if (target == null) {
            this.print(System.err);
            throw new RuntimeException("Message has no nextActorId, not sent");
        }
        if (target.getActorGroup() > config.getActorGroups()) {
            throw new RuntimeException("TargetActorId invalid ActorGroup, not sent");
        }
        if (route.getVerb() == null) {
            throw new RuntimeException("Verb missing, not sent");
        }
        return true;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public Instant getTimestamp() {
        return this.messageId.getTimestamp();
    }

    @Override
    public List<Route> getHistory() {
        LinkedList<Route> newHistory = new LinkedList<Route>();
        newHistory.addAll(this.history);
        return newHistory;
    }

    @Override
    public Route getRoute() {
        return this.currentRoute;
    }

    @Override
    public ActorId getTarget() {
        if (this.currentRoute == null) {
            return null;
        }
        return this.currentRoute.getTarget();
    }

    @Override
    public Verb getVerb() {
        if (this.currentRoute == null) {
            return null;
        }
        return this.currentRoute.getVerb();
    }

    @Override
    public List<Route> getRoutes() {
        return this.routes;
    }

    @Override
    public ActorId getNextActorId() {
        Route route = this.peekRoute();
        if (route == null) {
            return null;
        }
        return this.peekRoute().getTarget();
    }

    @Override
    public Verb getNextVerb() {
        if (this.routes.size() == 0) {
            return null;
        }
        return this.peekRoute().getVerb();
    }

    @Override
    public Route peekRoute() {
        if (this.routes.size() == 0) {
            return null;
        }
        Route route = this.routes.peek();
        return route;
    }

    public Route peekTailRoute() {
        return this.routes.getLast();
    }

    @Override
    public Route popRoute() {
        this.currentRoute = this.routes.pop();
        if (this.keepHistory) {
            this.history.add(this.currentRoute);
        }
        return this.currentRoute;
    }

    public void pushRoute(Route route) {
        this.routes.push(route);
    }

    @Override
    public Message keepHistory(boolean keepHistory) {
        this.keepHistory = keepHistory;
        if (keepHistory && this.history == null) {
            this.history = new LinkedList<Route>();
        }
        return this;
    }

    @Override
    public boolean isKeepHistory() {
        return this.keepHistory;
    }

    public Message trace(boolean trace) {
        return this;
    }

    @Override
    public Message copyRoutesFrom(Message inbound) {
        this.routes.addAll(inbound.getRoutes());
        return this;
    }

    protected Route prepareBuildRoute() {
        if (this.buildRoute == null) {
            this.buildRoute = new Route();
        }
        return this.buildRoute;
    }

    @Override
    public Message ask(ActorId actorId) {
        this.prepareBuildRoute().setTarget(actorId);
        return this;
    }

    @Override
    public Message ask(String key) {
        Object o = this.get(key);
        if (o == null) {
            throw new RuntimeException("The payload entry '" + key + "' is not found");
        }
        if (!(o instanceof ActorId)) {
            throw new RuntimeException("The payload entry '" + key + "' is not an ActorId");
        }
        ActorId actorId = (ActorId)o;
        this.prepareBuildRoute().setTarget(actorId);
        return this;
    }

    @Override
    public Message to(Verb verb) {
        if (this.buildRoute == null) {
            throw new RuntimeException("copy is not setup");
        }
        this.buildRoute.setVerb(verb);
        this.routes.addLast(this.buildRoute);
        this.buildRoute = null;
        return this;
    }

    public void toJson(PrintStream out) {
        out.println("no implemented");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Message Id: ");
        sb.append(this.getMessageId());
        sb.append("\n");
        if (this.getRoute() != null) {
            sb.append("Current route: \n");
            sb.append(this.getRoute());
            sb.append("\n");
        }
        if (!this.routes.isEmpty()) {
            sb.append("Route Stack:\n");
            for (Route route : this.routes) {
                sb.append("  ");
                sb.append(route);
                sb.append("\n");
            }
        }
        if (!this.history.isEmpty()) {
            sb.append("History:\n");
            for (Route route : this.history) {
                sb.append("  ");
                sb.append(route);
                sb.append("\n");
            }
        }
        if (!this.payload.isEmpty()) {
            sb.append("Payload:\n");
            for (Map.Entry entry : this.payload.entrySet()) {
                sb.append("  ");
                sb.append((String)entry.getKey());
                sb.append("=");
                sb.append(entry.getValue());
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public void print(PrintStream out) {
        out.print(this.toString());
    }

    @Override
    public Map<String, Object> getPayload() {
        return Map.copyOf(this.payload);
    }

    @Override
    public Message remove(String key) {
        this.payload.remove(key);
        return this;
    }

    @Override
    public Message put(String key, Object value) {
        this.payload.put(key, value);
        return this;
    }

    @Override
    public Message put(String key, String value) {
        this.payload.put(key, value);
        return this;
    }

    @Override
    public Message put(String key, Integer value) {
        this.payload.put(key, value);
        return this;
    }

    @Override
    public Message put(String key, ActorId value) {
        this.payload.put(key, value);
        return this;
    }

    @Override
    public Object get(String key) {
        return this.payload.get(key);
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        Object o = this.get(key);
        if (o == null) {
            throw new RuntimeException("Info entry '" + key + "' not found");
        }
        if (o.getClass().isAssignableFrom(clazz)) {
            return (T)o;
        }
        throw new RuntimeException("Payload entry is not a " + clazz.getSimpleName() + " type");
    }

    @Override
    public String getString(String key) {
        Object o = this.get(key);
        if (o == null) {
            throw new RuntimeException("Info entry '" + key + "' not found");
        }
        if (o instanceof String) {
            String si = (String)o;
            return si;
        }
        throw new RuntimeException("Payload entry is not a String type");
    }

    @Override
    public int getInteger(String key) {
        Object o = this.get(key);
        if (o == null) {
            throw new RuntimeException("Info entry '" + key + "' not found");
        }
        if (o instanceof Integer) {
            Integer si = (Integer)o;
            return si;
        }
        throw new RuntimeException("Payload entry is not a Integer type");
    }

    @Override
    public ActorId getActorId(String key) {
        Object o = this.get(key);
        if (o == null) {
            throw new RuntimeException("Info entry '" + key + "' not found");
        }
        if (o instanceof ActorId) {
            ActorId actorId = (ActorId)o;
            return actorId;
        }
        throw new RuntimeException("Payload entry is not a ActorId type");
    }

    @Override
    public boolean preprocess(Config config, Actor actor) {
        return true;
    }

    @Override
    public boolean postprocess(Config config, Actor actor) {
        return true;
    }

    @Override
    public Stage notImplemented(Config config, Actor actor) {
        return actor.getEmptyStage();
    }

    @Override
    public void terminal(Config config, Actor actor) {
    }
}

