/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.host;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.Config;
import net.sodacan.core.Coordinator;
import net.sodacan.core.Host;
import net.sodacan.core.Jug;
import net.sodacan.core.coordinator.HostEntry;
import net.sodacan.core.jug.NormalMessage;
import net.sodacan.core.scheduler.Statistics;

public abstract class AbstractHost
implements Host {
    private Config config;
    private int hostNumber;
    private boolean initialized = false;
    private Coordinator coordinator;
    protected Map<HostEntry, ActorGroup> activeActorGroups = new ConcurrentHashMap<HostEntry, ActorGroup>();

    public AbstractHost(Config config) {
        this.config = config;
        this.hostNumber = config.getHostNumber();
        this.coordinator = this.getConfig().getCoordinator();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public int getHostNumber() {
        return this.hostNumber;
    }

    @Override
    public Map<Integer, Statistics> getActorGroupStatistics() {
        HashMap<Integer, Statistics> stats = new HashMap<Integer, Statistics>();
        for (Map.Entry<HostEntry, ActorGroup> entry : this.activeActorGroups.entrySet()) {
            stats.put(entry.getValue().getActorGroupNumber(), entry.getValue().getScheduler().getStatistics());
        }
        return stats;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public void update() {
        List<HostEntry> actorGroups = this.coordinator.getActorGroupsForHost();
        actorGroups.add(new HostEntry(this.config.getHostNumber(), -this.config.getHostNumber(), HostEntry.Mode.Host));
        for (Map.Entry<HostEntry, ActorGroup> entry : this.activeActorGroups.entrySet()) {
            if (actorGroups.contains(entry.getKey())) continue;
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to close ActorGroup " + String.valueOf(entry.getValue()), e);
            }
            this.activeActorGroups.remove(entry.getKey());
        }
        for (HostEntry hostEntry : actorGroups) {
            if (this.activeActorGroups.containsKey(hostEntry)) continue;
            ActorGroup ag = this.config.createActorGroup(hostEntry.getActorGroup());
            ag.setHost(this);
            this.activeActorGroups.put(hostEntry, ag);
        }
    }

    @Override
    public Set<HostEntry> getHostEntries() {
        return this.activeActorGroups.keySet();
    }

    @Override
    public ActorGroup getActorGroup(HostEntry hostEntry) {
        return this.activeActorGroups.get(hostEntry);
    }

    @Override
    public Set<ActorGroup> getActorGroups() {
        Set<HostEntry> hes = this.getHostEntries();
        HashSet<ActorGroup> ags = new HashSet<ActorGroup>();
        for (HostEntry he : hes) {
            ags.add(this.getActorGroup(he));
        }
        return ags;
    }

    @Override
    public void close() throws IOException {
        for (ActorGroup ag : this.getActorGroups()) {
            if (ag.getActorGroupNumber() >= 0) continue;
            ag.close();
        }
        for (ActorGroup ag : this.getActorGroups()) {
            if (ag.getActorGroupNumber() <= 0) continue;
            ag.close();
        }
        this.activeActorGroups.clear();
    }

    protected void replicate(int host, NormalMessage nm) {
        System.out.println("Message " + String.valueOf(nm) + " replicated to host " + host);
    }

    protected void forwardToHost(int hostNumber, NormalMessage nm) {
    }

    @Override
    public boolean send(Jug jug) {
        Jug jug2 = jug;
        Objects.requireNonNull(jug2);
        Jug jug3 = jug2;
        int n = 0;
        return this.sendNormalMessage(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NormalMessage.class}, (Object)jug3, n)) {
            case 0 -> (NormalMessage)jug3;
            default -> throw new RuntimeException("Invalid Jug receied by host");
        });
    }

    protected boolean sendNormalMessage(NormalMessage nm) {
        this.initialize();
        int agNumber = nm.getActorId().getActorGroup();
        HostEntry he = agNumber < 0 ? new HostEntry(this.getHostNumber(), agNumber, HostEntry.Mode.Host) : new HostEntry(this.getHostNumber(), agNumber, HostEntry.Mode.Live);
        ActorGroup ag = this.activeActorGroups.get(he);
        if (ag != null) {
            ag.addMessage(nm);
            for (Integer replicationHost : this.coordinator.getHostsForActorGroup(agNumber)) {
                if (replicationHost == agNumber) continue;
                this.replicate(replicationHost, nm);
            }
        } else {
            this.forwardToHost(this.coordinator.getLiveHostForActorGroup(agNumber), nm);
        }
        return true;
    }

    @Override
    public void waitForMessagesToFinish() {
        for (Map.Entry<HostEntry, ActorGroup> entry : this.activeActorGroups.entrySet()) {
            if (entry.getValue().getActorGroupNumber() <= 0) continue;
            entry.getValue().getScheduler().waitForMessagesToFinish();
        }
    }
}

