/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.config;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sodacan.core.Actor;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.ActorGroupAssigner;
import net.sodacan.core.ActorId;
import net.sodacan.core.ActorIdFactory;
import net.sodacan.core.Config;
import net.sodacan.core.Coordinator;
import net.sodacan.core.Host;
import net.sodacan.core.Message;
import net.sodacan.core.MessageId;
import net.sodacan.core.Scheduler;
import net.sodacan.core.actor.UUIDActorIdFactory;
import net.sodacan.core.actorgroup.DefaultActorGroup;
import net.sodacan.core.actorgroup.RandomActorGroupAssigner;
import net.sodacan.core.config.ActorMetadata;
import net.sodacan.core.coordinator.SingleHostCoordinator;
import net.sodacan.core.host.DefaultHost;
import net.sodacan.core.message.DefaultMessage;
import net.sodacan.core.message.DefaultMessageId;
import net.sodacan.core.persist.PersisterFactory;
import net.sodacan.core.persist.file.FilePersisterFactory;
import net.sodacan.core.scheduler.DefaultScheduler;
import net.sodacan.core.serialize.SerializerFactory;
import net.sodacan.core.serialize.gson.GsonSerializerFactory;
import net.sodacan.core.util.ClassUtilities;
import org.apache.ratis.thirdparty.io.netty.util.internal.ThreadLocalRandom;

public class DefaultConfig
implements Config {
    private int hostNumber;
    private int actorGroups;
    private int actorGroupReplicas;
    private Function<Config, Integer> backpressureLimitFn;
    private Function<Config, Integer> backpressureWaitMsFn;
    private Function<Config, Integer> evictionFn;
    private Function<Config, Integer> actorGroupThreadsFn;
    private Function<Config, Integer> shutdownWaitMsFn;
    private Function<Config, MessageId> messageIdFn;
    private Function<Config, Message> messageFn;
    private Host host;
    private Clock clock;
    private Function<Config, Random> randomFn;
    private String rootDirectory;
    private ActorGroupAssigner actorGroupAssigner;
    private Coordinator coordinator;
    private BiFunction<Config, ActorGroup, Scheduler> schedulerFn;
    private BiFunction<Config, Integer, ActorGroup> actorGroupFn;
    private PersisterFactory persisterFactory;
    private SerializerFactory serializerFactory;
    private Map<String, Class<? extends Actor>> actorTypes;
    private Map<String, ActorMetadata> actorMetadata;
    private Map<String, BiFunction<Config, ActorId, Actor>> actorFactories;
    private ActorIdFactory actorIdFactory;

    private DefaultConfig(Builder builder) {
        this.hostNumber = builder.hostNumberFn.apply(this);
        if (this.hostNumber < 0) {
            throw new RuntimeException("The hostNumber must be positive");
        }
        this.actorGroupReplicas = builder.actorGroupReplicasFn.apply(this);
        if (this.actorGroupReplicas < 0) {
            throw new RuntimeException("The number of actorGroup replicas must be a positive number");
        }
        this.actorGroups = builder.actorGroupsFn.apply(this);
        if (this.actorGroups < 1) {
            throw new RuntimeException("The number of actorGroups must be 1 or greater");
        }
        this.coordinator = builder.coordinatorFn.apply(this);
        this.host = builder.hostFn.apply(this);
        this.clock = builder.clockFn.apply(this);
        this.randomFn = builder.randomFn;
        this.rootDirectory = builder.rootDirectoryFn.apply(this);
        this.actorGroupThreadsFn = builder.actorGroupThreadsFn;
        this.actorGroupAssigner = builder.actorGroupAssignerFn.apply(this);
        this.messageIdFn = builder.messageIdFn;
        this.messageFn = builder.messageFn;
        this.schedulerFn = builder.schedulerFn;
        this.actorGroupFn = builder.actorGroupFn;
        this.actorIdFactory = builder.actorIdFactoryFn.apply(this);
        this.actorTypes = builder.actorTypes;
        this.backpressureLimitFn = builder.backpressureLimitFn;
        this.evictionFn = builder.evictionFn;
        this.backpressureWaitMsFn = builder.backpressureWaitMsFn;
        this.shutdownWaitMsFn = builder.shutdownWaitMsFn;
        this.actorFactories = builder.actorFactories;
        this.addMissingActorFactories();
        this.setupMetadata();
        this.serializerFactory = builder.serializerFactoryFn.apply(this);
        this.persisterFactory = builder.persisterFactoryFn.apply(this);
    }

    protected void setupMetadata() {
        this.actorMetadata = new HashMap<String, ActorMetadata>();
        for (Map.Entry<String, Class<? extends Actor>> entry : this.actorTypes.entrySet()) {
            this.actorMetadata.put(entry.getKey(), new ActorMetadata(entry.getValue()));
        }
    }

    protected void addMissingActorFactories() {
        try {
            for (Map.Entry<String, Class<? extends Actor>> entry : this.actorTypes.entrySet()) {
                if (this.actorFactories.containsKey(entry.getKey())) continue;
                Class<? extends Actor> clazz = entry.getValue();
                if (clazz == null) {
                    throw new RuntimeException("Actor class not found: " + entry.getKey());
                }
                Constructor<?>[] ctrs = entry.getValue().getDeclaredConstructors();
                boolean matchingConstructor = false;
                for (Constructor<?> ctor : ctrs) {
                    Parameter[] parameters;
                    if (ctor.getParameterCount() != 2 || (parameters = ctor.getParameters())[0].getType() != Config.class || parameters[1].getType() != ActorId.class) continue;
                    matchingConstructor = true;
                }
                if (!matchingConstructor) {
                    throw new RuntimeException("Actor " + entry.getKey() + " Does not support a standard constructor, use a custom factory");
                }
                Constructor<? extends Actor> ctor = entry.getValue().getDeclaredConstructor(Config.class, ActorId.class);
                BiFunction<Config, ActorId, Actor> f = (config, actorId) -> {
                    try {
                        return (Actor)ctor.newInstance(config, actorId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error constructing actor " + (String)entry.getKey(), e);
                    }
                };
                this.actorFactories.put(entry.getKey(), f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating default actor factories", e);
        }
    }

    @Override
    public int getHostNumber() {
        return this.hostNumber;
    }

    @Override
    public int getActorGroups() {
        return this.actorGroups;
    }

    @Override
    public int getActorGroupReplicas() {
        return this.actorGroupReplicas;
    }

    @Override
    public synchronized int getBackpressureLimit() {
        int limit = this.backpressureLimitFn.apply(this);
        if (limit < 1) {
            throw new RuntimeException("Backpressure limit must be a positive number");
        }
        return limit;
    }

    @Override
    public synchronized int getEviction() {
        return this.evictionFn.apply(this);
    }

    @Override
    public ActorGroupAssigner getActorGroupAssigner() {
        return this.actorGroupAssigner;
    }

    @Override
    public MessageId createMessageId() {
        return this.messageIdFn.apply(this);
    }

    @Override
    public Message createMessage() {
        return this.messageFn.apply(this);
    }

    @Override
    public ActorId createActorId(String actorType) {
        return this.actorIdFactory.create(actorType);
    }

    @Override
    public synchronized int getActorGroupThreads() {
        return this.actorGroupThreadsFn.apply(this);
    }

    @Override
    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public Random getRandom() {
        return this.randomFn.apply(this);
    }

    @Override
    public synchronized ActorGroup createActorGroup(int actorGroupNumber) {
        return this.actorGroupFn.apply(this, actorGroupNumber);
    }

    @Override
    public synchronized Scheduler createScheduler(ActorGroup actorGroup) {
        return this.schedulerFn.apply(this, actorGroup);
    }

    @Override
    public synchronized int getBackpressureWaitMs() {
        return this.backpressureWaitMsFn.apply(this);
    }

    @Override
    public synchronized int getShutdownWaitMs() {
        return this.shutdownWaitMsFn.apply(this);
    }

    @Override
    public String getProperty(String name) {
        return System.getProperty(name);
    }

    @Override
    public String getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    public Class<? extends Actor> getActorClass(String actorType) {
        Class<? extends Actor> ac = this.actorTypes.get(actorType);
        if (ac == null) {
            throw new RuntimeException("Unknown ActorType: " + actorType);
        }
        return ac;
    }

    @Override
    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    @Override
    public PersisterFactory getPersisterFactory() {
        return this.persisterFactory;
    }

    @Override
    public ActorMetadata getActorMetadata(String actorType) {
        ActorMetadata am = this.actorMetadata.get(actorType);
        if (am == null) {
            throw new RuntimeException("Unknown ActorType: " + actorType);
        }
        return am;
    }

    @Override
    public Map<String, Class<? extends Actor>> getActorTypes() {
        return this.actorTypes;
    }

    @Override
    public Actor createActor(ActorId actorId) {
        String actorType = actorId.getType();
        if (actorType == null) {
            throw new RuntimeException("Null ActorType not allowed");
        }
        BiFunction<Config, ActorId, Actor> factory = this.actorFactories.get(actorType);
        if (factory == null) {
            throw new RuntimeException("No factory for actorType " + actorType);
        }
        return factory.apply(this, actorId);
    }

    @Override
    public void printConfig(PrintStream out) {
        out.println("Local Static");
        out.println(" Host: " + String.valueOf(this.getHost()));
        out.println(" hostNumber=" + this.getHostNumber());
        out.println("Global Static");
        out.println("  actorGroups=" + this.getActorGroups());
        out.println("  actorGroupReplicas=" + this.getActorGroupReplicas());
        out.println("Local Static factory");
        out.println(" Coordinator: " + String.valueOf(this.getCoordinator()));
        out.println(" actorGroupAssigner=" + String.valueOf(this.getActorGroupAssigner()));
        out.println("Global Dynamic");
        out.println(" backpressureLimit=" + this.getBackpressureLimit());
        out.println(" backpressureWaitMs=" + this.getBackpressureWaitMs());
        out.println(" eviction=" + this.getEviction());
        out.println(" actorGroupThreads=" + this.getActorGroupThreads());
        out.println(" shutdownWaitMs=" + this.getShutdownWaitMs());
        out.println("Property: os.name=" + this.getProperty("os.name"));
        out.println("actors: ");
        this.listActors(out);
    }

    @Override
    public void listActors(PrintStream out) {
        for (Map.Entry<String, Class<? extends Actor>> entry : this.actorTypes.entrySet()) {
            out.print("  ");
            out.print(entry.getKey());
            out.print("=");
            out.println(entry.getValue().getName());
        }
    }

    public static class Builder {
        private Function<Config, Integer> hostNumberFn = config -> 1;
        private Function<Config, Clock> clockFn = config -> Clock.systemUTC();
        private Function<Config, Random> randomFn = config -> ThreadLocalRandom.current();
        private Function<Config, String> rootDirectoryFn = config -> System.getProperty("java.io.tmpdir");
        private Function<Config, Integer> actorGroupsFn = config -> 1;
        private Function<Config, Integer> actorGroupReplicasFn = config -> 0;
        private Function<Config, Integer> backpressureLimitFn = config -> 100000;
        private Function<Config, Integer> backpressureWaitMsFn = config -> 200;
        private Function<Config, Integer> shutdownWaitMsFn = config -> 200;
        private Function<Config, Integer> evictionFn = config -> 8;
        private Function<Config, Integer> actorGroupThreadsFn = config -> 20;
        private Function<Config, ActorGroupAssigner> actorGroupAssignerFn = config -> new RandomActorGroupAssigner((Config)config);
        private BiFunction<Config, ActorGroup, Scheduler> schedulerFn = (config, ag) -> new DefaultScheduler((Config)config, (ActorGroup)ag);
        private Function<Config, ActorIdFactory> actorIdFactoryFn = config -> new UUIDActorIdFactory((Config)config);
        private BiFunction<Config, Integer, ActorGroup> actorGroupFn = (config, id) -> new DefaultActorGroup((Config)config, (int)id);
        private Function<Config, Coordinator> coordinatorFn = config -> new SingleHostCoordinator((Config)config);
        private Function<Config, Host> hostFn = config -> new DefaultHost((Config)config);
        private Function<Config, MessageId> messageIdFn = config -> new DefaultMessageId((Config)config);
        private Function<Config, Message> messageFn = config -> new DefaultMessage(config.createMessageId());
        private Function<Config, PersisterFactory> persisterFactoryFn = config -> new FilePersisterFactory((Config)config);
        private Function<Config, SerializerFactory> serializerFactoryFn = config -> new GsonSerializerFactory((Config)config);
        private Map<String, Class<? extends Actor>> actorTypes = new HashMap<String, Class<? extends Actor>>();
        private Map<String, BiFunction<Config, ActorId, Actor>> actorFactories = new HashMap<String, BiFunction<Config, ActorId, Actor>>();

        public Builder hostNumber(int hostNumber) {
            this.hostNumberFn = config -> hostNumber;
            return this;
        }

        public Builder hostNumber(Function<Config, Integer> hostNumberFn) {
            this.hostNumberFn = hostNumberFn;
            return this;
        }

        public Builder clock(Function<Config, Clock> clockFn) {
            this.clockFn = clockFn;
            return this;
        }

        public Builder random(Function<Config, Random> randomFn) {
            this.randomFn = randomFn;
            return this;
        }

        public Builder rootDirectory(String rootDirectory) {
            this.rootDirectoryFn = config -> rootDirectory;
            return this;
        }

        public Builder rootDirectory(Function<Config, String> rootDirectoryFn) {
            this.rootDirectoryFn = rootDirectoryFn;
            return this;
        }

        public Builder actorGroups(int actorGroups) {
            this.actorGroupsFn = config -> actorGroups;
            return this;
        }

        public Builder actorGroups(Function<Config, Integer> actorGroupsFn) {
            this.actorGroupsFn = actorGroupsFn;
            return this;
        }

        public Builder actorGroupReplicas(int actorGroupReplicas) {
            this.actorGroupReplicasFn = config -> actorGroupReplicas;
            return this;
        }

        public Builder actorGroupReplicas(Function<Config, Integer> actorGroupReplicasFn) {
            this.actorGroupReplicasFn = actorGroupReplicasFn;
            return this;
        }

        public Builder eviction(int eviction) {
            this.evictionFn = config -> eviction;
            return this;
        }

        public Builder eviction(Function<Config, Integer> evictionFn) {
            this.evictionFn = evictionFn;
            return this;
        }

        public Builder actorGroupThreads(int actorGroupThreads) {
            this.actorGroupThreadsFn = config -> actorGroupThreads;
            return this;
        }

        public Builder actorGroupThreads(Function<Config, Integer> actorGroupThreadsFn) {
            this.actorGroupThreadsFn = actorGroupThreadsFn;
            return this;
        }

        public Builder backpressureLimit(Function<Config, Integer> backpressureLimitFn) {
            this.backpressureLimitFn = backpressureLimitFn;
            return this;
        }

        public Builder backpressureLimit(int backpressureLimit) {
            this.backpressureLimitFn = config -> backpressureLimit;
            return this;
        }

        public Builder backpressureWaitMs(Function<Config, Integer> backpressureWaitMsFn) {
            this.backpressureWaitMsFn = backpressureWaitMsFn;
            return this;
        }

        public Builder backpressureWaitMs(int backpressureWaitMs) {
            this.backpressureWaitMsFn = config -> backpressureWaitMs;
            return this;
        }

        public Builder actorGroupAssigner(Function<Config, ActorGroupAssigner> actorGroupAssignerFn) {
            this.actorGroupAssignerFn = actorGroupAssignerFn;
            return this;
        }

        public Builder messageId(Function<Config, MessageId> messageIdFn) {
            this.messageIdFn = messageIdFn;
            return this;
        }

        public Builder persisterFactory(Function<Config, PersisterFactory> persisterFactoryFn) {
            this.persisterFactoryFn = persisterFactoryFn;
            return this;
        }

        public Builder serializerFactory(Function<Config, SerializerFactory> serializerFactoryFn) {
            this.serializerFactoryFn = serializerFactoryFn;
            return this;
        }

        public Builder message(Function<Config, Message> messageFn) {
            this.messageFn = messageFn;
            return this;
        }

        public Builder registerActorsInPackage(String packageName) {
            try {
                ClassUtilities.getActorClassesFromPackage(packageName, this.actorTypes);
            }
            catch (Exception e) {
                throw new RuntimeException("Trouble loading Actors from package " + packageName, e);
            }
            return this;
        }

        public Builder registerActorType(String actorType, Class<? extends Actor> type) {
            if (this.actorTypes.containsKey(actorType)) {
                throw new RuntimeException("Duplicate type assignment: " + actorType);
            }
            this.actorTypes.put(actorType, type);
            return this;
        }

        public Builder actorFactory(String actorType, BiFunction<Config, ActorId, Actor> actorFactory) {
            this.actorFactories.put(actorType, actorFactory);
            return this;
        }

        public Builder shutdownWaitMs(Function<Config, Integer> ms) {
            this.shutdownWaitMsFn = ms;
            return this;
        }

        public Builder shutdownWaitMs(int ms) {
            this.shutdownWaitMsFn = config -> ms;
            return this;
        }

        public Builder coordinator(Function<Config, Coordinator> coordinatorFn) {
            this.coordinatorFn = coordinatorFn;
            return this;
        }

        public Builder host(Function<Config, Host> hostFn) {
            this.hostFn = hostFn;
            return this;
        }

        public Builder schedulerCreator(BiFunction<Config, ActorGroup, Scheduler> schedulerFn) {
            this.schedulerFn = schedulerFn;
            return this;
        }

        public Builder actorIdFactory(Function<Config, ActorIdFactory> actorIdFactoryFn) {
            this.actorIdFactoryFn = actorIdFactoryFn;
            return this;
        }

        public Builder actorGroupCreator(BiFunction<Config, Integer, ActorGroup> actorGroupFn) {
            this.actorGroupFn = actorGroupFn;
            return this;
        }

        public Builder property(String name, String value) {
            System.setProperty(name, value);
            return this;
        }

        public Config build() {
            return new DefaultConfig(this);
        }
    }
}

