/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sodacan.core.Actor;
import net.sodacan.core.annotation.Save;

public class ActorMetadata {
    protected Class<? extends Actor> actorClass;
    protected Map<String, Field> saveFields = null;
    protected Set<Class<?>> generics = new TreeSet<Class>(Comparator.comparing(Class::getName));

    public ActorMetadata(Class<? extends Actor> actorClass) {
        this.actorClass = actorClass;
        this.loadFieldMetadata();
    }

    public Map<String, Field> getSaveFields() {
        return this.saveFields;
    }

    protected void loadFieldMetadata() {
        Field[] fields;
        this.saveFields = new HashMap<String, Field>();
        for (Field field : fields = this.actorClass.getDeclaredFields()) {
            Save save = field.getAnnotation(Save.class);
            if (save == null) continue;
            if (save.name() == null || save.name().isBlank()) {
                throw new RuntimeException("Missing @Save name");
            }
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new RuntimeException("Field " + field.getName() + " in " + this.actorClass.getSimpleName() + " must be public");
            }
            if (save == null) continue;
            this.generics.add(field.getType());
            this.saveFields.put(save.name(), field);
        }
    }
}

