/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.actorgroup;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.sodacan.core.Actor;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Host;
import net.sodacan.core.Jug;
import net.sodacan.core.Message;
import net.sodacan.core.Scheduler;
import net.sodacan.core.jug.CloseHostBoundActor;
import net.sodacan.core.jug.NormalMessage;

public abstract class AbstractActorGroup
implements ActorGroup {
    private Config config;
    private int actorGroupNumber;
    private Scheduler scheduler;
    protected Host host = null;
    protected CountDownLatch closeLatch = null;

    public AbstractActorGroup(Config config, int actorGroupNumber) {
        this.config = config;
        this.actorGroupNumber = actorGroupNumber;
        if (actorGroupNumber > 0 && actorGroupNumber > config.getActorGroups() || actorGroupNumber == 0) {
            throw new RuntimeException("actorGroup number (" + actorGroupNumber + ") out of range");
        }
        this.scheduler = config.createScheduler(this);
        this.host = config.getHost();
        if (actorGroupNumber < 0) {
            for (Map.Entry<String, Class<? extends Actor>> entry : config.getActorTypes().entrySet()) {
                String actorType = entry.getKey();
                if (!actorType.startsWith("$")) continue;
                ActorId actorId = new ActorId(entry.getKey(), -config.getHostNumber(), "host");
                this.sendStartMessage(actorId);
            }
        }
    }

    protected void sendStartMessage(ActorId actorId) {
        Message m = this.config.createMessage();
        m.ask(actorId).to(Actor.Builtin.Start);
        byte[] bytes = this.config.getSerializerFactory().create(actorId).serialize(m);
        NormalMessage nm = new NormalMessage(actorId, bytes);
        this.addMessage(nm);
    }

    @Override
    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void close() throws IOException, RuntimeException {
        if (this.actorGroupNumber < 0) {
            LinkedList<ActorId> closeActors = new LinkedList<ActorId>();
            for (Map.Entry<String, Class<? extends Actor>> entry : this.config.getActorTypes().entrySet()) {
                String actorType = entry.getKey();
                if (!actorType.startsWith("$")) continue;
                ActorId actorId = new ActorId(entry.getKey(), -this.config.getHostNumber(), "host");
                closeActors.add(actorId);
            }
            this.closeLatch = new CountDownLatch(closeActors.size());
            for (ActorId actorId : closeActors) {
                this.addMessage(new CloseHostBoundActor(actorId, this.closeLatch));
            }
            try {
                this.closeLatch.await();
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating close latch", e);
            }
        }
        this.scheduler.close();
        System.out.println("Actor group closed: " + String.valueOf(this));
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public int getActorGroupNumber() {
        return this.actorGroupNumber;
    }

    public void increaseMessageLoad() {
        this.scheduler.increaseMessageLoad();
    }

    public void reduceMessageLoad() {
        this.scheduler.decreaseMessageLoad();
    }

    public String toString() {
        return "ActorGroupNumber=" + this.getActorGroupNumber();
    }

    @Override
    public void addMessage(Jug jug) {
        this.getScheduler().addNewMessage(jug);
    }
}

