/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.actor;

import java.util.UUID;
import net.sodacan.core.ActorId;
import net.sodacan.core.ActorIdFactory;
import net.sodacan.core.Config;

public class UUIDActorIdFactory
implements ActorIdFactory {
    Config config;

    public UUIDActorIdFactory(Config config) {
        this.config = config;
    }

    @Override
    public ActorId create(String actorType) {
        if (this.config.getActorClass(actorType) == null) {
            throw new RuntimeException("Invalid ActorType: " + actorType);
        }
        String id = UUID.randomUUID().toString();
        int actorGroup = this.config.getActorGroupAssigner().assign(actorType, id);
        if (actorGroup < 0) {
            id = "host";
        }
        return new ActorId(actorType, actorGroup, id);
    }
}

