/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.actor;

import java.util.concurrent.atomic.AtomicLong;
import net.sodacan.core.ActorId;
import net.sodacan.core.ActorIdFactory;
import net.sodacan.core.Config;

public class SequentialActorIdFactory
implements ActorIdFactory {
    Config config;
    private AtomicLong seq = new AtomicLong(0L);

    public SequentialActorIdFactory(Config config) {
        this.config = config;
    }

    @Override
    public ActorId create(String actorType) {
        if (this.config.getActorClass(actorType) == null) {
            throw new RuntimeException("Invalid ActorType: " + actorType);
        }
        String id = Long.toString(this.seq.incrementAndGet());
        int actorGroup = this.config.getActorGroupAssigner().assign(actorType, id);
        if (actorGroup < 0) {
            id = "host";
        }
        return new ActorId(actorType, actorGroup, id);
    }
}

