/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.actor;

import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sodacan.core.Actor;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Jug;
import net.sodacan.core.Scheduler;
import net.sodacan.core.Serializer;
import net.sodacan.core.jug.CloseHostBoundActor;
import net.sodacan.core.jug.ErrorMessage;
import net.sodacan.core.jug.NormalMessage;
import net.sodacan.core.jug.StoppedActor;

public class ActorEntry
extends Thread
implements Runnable {
    private AtomicBoolean running = new AtomicBoolean(false);
    private boolean initialized = false;
    protected ActorId actorId = null;
    protected Actor actor = null;
    private BlockingQueue<Jug> queue = new LinkedBlockingQueue<Jug>();
    protected Scheduler scheduler;
    protected Config config;
    protected long usage = 0L;
    protected boolean evicting = false;
    protected Serializer serializer;
    private int lingerCount = 0;

    public ActorId getActorId() {
        return this.actorId;
    }

    public long getUsage() {
        return this.usage;
    }

    public void startThread(ThreadPoolExecutor pool) {
        if (this.running.compareAndSet(false, true)) {
            pool.execute(this);
        }
    }

    public void stopThread() {
        if (this.running.compareAndSet(true, false)) {
            // empty if block
        }
    }

    public ActorEntry(Config config, Scheduler scheduler, ActorId actorId) {
        this.config = config;
        this.scheduler = scheduler;
        this.actorId = actorId;
    }

    public void queueMessage(Jug jug) {
        this.queue.add(jug);
    }

    protected void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.actor == null) {
            this.actor = this.config.createActor(this.actorId);
            this.actor.setActorGroup(this.scheduler.getActorGroup());
            this.scheduler.incrementActorsCreated();
            this.actor.restore();
        }
        this.initialized = true;
    }

    protected boolean linger() throws InterruptedException {
        if (this.evictionProbability() > 0.1f) {
            return false;
        }
        if (++this.lingerCount > 2) {
            this.lingerCount = 0;
            return false;
        }
        Thread.sleep(Duration.ofMillis(2L));
        return true;
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            boolean more;
            Jug jug;
            Jug jug2 = jug = (Jug)this.queue.poll();
            int n = 0;
            if (more = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CloseHostBoundActor.class, NormalMessage.class}, (Object)jug2, n)) {
                case -1 -> this.emptyQueue();
                case 0 -> {
                    CloseHostBoundActor chba = (CloseHostBoundActor)jug2;
                    yield this.closeHostBoundActor(chba);
                }
                case 1 -> {
                    NormalMessage nm = (NormalMessage)jug2;
                    yield this.normalMessage(nm);
                }
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(jug));
            })) continue;
            break;
        }
        this.scheduler.increaseMessageLoad();
        this.actor.exitingThread();
        this.scheduler.decreaseMessageLoad();
        this.stopThread();
    }

    protected boolean emptyQueue() {
        try {
            if (this.linger()) {
                return true;
            }
            this.scheduler.addMessage(new StoppedActor(this.actorId));
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating StoppedActor message", e);
        }
    }

    protected boolean closeHostBoundActor(CloseHostBoundActor chba) {
        this.actor.close();
        chba.countDown();
        this.scheduler.decreaseMessageLoad();
        return false;
    }

    protected boolean normalMessage(NormalMessage nm) {
        try {
            this.initialize();
            this.actor.callProcessMessage(nm);
            this.scheduler.decreaseMessageLoad();
        }
        catch (Throwable e) {
            System.err.println("Exception in actor " + String.valueOf(this.actorId));
            this.scheduler.addMessage(new ErrorMessage(this.actorId, nm.getMessage(), e));
        }
        return true;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public float evictionProbability() {
        if (this.actor == null) {
            return 1.0f;
        }
        return this.actor.evictionProbability();
    }

    @Override
    public String toString() {
        return "Entry for " + this.actorId.toString();
    }
}

