/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.actor;

import java.util.Map;
import net.sodacan.core.Actor;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Message;
import net.sodacan.core.Persister;
import net.sodacan.core.Route;
import net.sodacan.core.Serializer;
import net.sodacan.core.Stage;
import net.sodacan.core.jug.NormalMessage;
import net.sodacan.core.scheduler.Statistics;

public abstract class AbstractActor
implements Actor {
    private ActorId actorId;
    private Config config;
    private ActorGroup actorGroup;
    private Serializer serializer;
    private Persister persister;
    public static Stage emptyStage = new Stage();

    public AbstractActor(Config config, ActorId actorId) {
        this.config = config;
        this.actorId = actorId;
        this.serializer = config.getSerializerFactory().create(actorId);
        this.persister = config.getPersisterFactory().create(actorId);
    }

    @Override
    public float evictionProbability() {
        return 0.5f;
    }

    @Override
    public void callProcessMessage(NormalMessage nm) {
        Message message = this.serializer.deserialize(nm.getMessage());
        message.preprocess(this.config, this);
        message.popRoute();
        Stage stage = this.processMessage(message);
        this.handleStage(stage);
    }

    protected void handleStage(Stage stage) {
        for (Message msg : stage.getMessages()) {
            this.send(msg);
        }
    }

    @Override
    public void send(Message m) {
        Route route;
        if (m.peekRoute() == null) {
            m.terminal(this.config, this);
        } else if (m.postprocess(this.config, this) && (route = m.peekRoute()) != null) {
            Serializer serializer = this.config.getSerializerFactory().create(route.getTarget());
            NormalMessage jug = new NormalMessage(route.getTarget(), serializer.serialize(m));
            this.config.getHost().send(jug);
        }
    }

    @Override
    public Stage processMessage(Message message) {
        return message.notImplemented(this.config, this);
    }

    public Map<Integer, Statistics> getLiveActorGroupStatistics() {
        return this.config.getHost().getActorGroupStatistics();
    }

    @Override
    public void close() {
    }

    @Override
    public void save() {
        byte[] ba = this.serializer.serialize(this);
        if (ba != null) {
            this.persister.write("", ba);
        }
    }

    @Override
    public void restore() {
        byte[] ba = this.persister.read("");
        if (ba != null) {
            this.serializer.deserialize(ba, this);
        }
    }

    @Override
    public void exitingThread() {
        this.save();
    }

    protected Stage reject(Message message, String reason) {
        Stage stage = new Stage();
        return stage;
    }

    protected void rollback() {
    }

    @Override
    public ActorId getActorId() {
        return this.actorId;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public ActorGroup getActorGroup() {
        return this.actorGroup;
    }

    @Override
    public void setActorGroup(ActorGroup actorGroup) {
        this.actorGroup = actorGroup;
    }

    @Override
    public Stage getEmptyStage() {
        return emptyStage;
    }
}

