/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.util.Map;
import net.sodacan.core.Config;
import net.sodacan.core.config.DefaultConfig;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;

public class Main {
    public static void main(String[] args) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(8080);
        connector.setHost("127.0.0.1");
        server.addConnector((Connector)connector);
        Handler.Sequence sequence = new Handler.Sequence(new Handler[0]);
        sequence.addHandler((Handler)new ConfigHandler());
        sequence.addHandler((Handler)new TimeHandler());
        sequence.addHandler((Handler)new FancyHandler());
        server.setHandler((Handler)sequence);
        server.start();
    }

    static class ConfigHandler
    extends Handler.Abstract {
        Config config = new DefaultConfig.Builder().build();

        ConfigHandler() {
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            if (!HttpMethod.GET.is(request.getMethod())) {
                return false;
            }
            if (!request.getHttpURI().getPath().equals("/config/")) {
                return false;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.config.printConfig(new PrintStream(baos));
            response.setStatus(200);
            Content.Sink.write((Content.Sink)response, (boolean)true, (String)baos.toString(), (Callback)callback);
            return true;
        }
    }

    static class TimeHandler
    extends Handler.Abstract {
        TimeHandler() {
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            if (!HttpMethod.GET.is(request.getMethod())) {
                return false;
            }
            if (!request.getHttpURI().getPath().equals("/time/")) {
                return false;
            }
            response.setStatus(200);
            Content.Sink.write((Content.Sink)response, (boolean)true, (String)Instant.now().toString(), (Callback)callback);
            return true;
        }
    }

    static class FancyHandler
    extends Handler.Abstract {
        private static UriTemplatePathSpec template = new UriTemplatePathSpec("/fancy/{number}/{string}");

        FancyHandler() {
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            if (!HttpMethod.GET.is(request.getMethod())) {
                return false;
            }
            String path = request.getHttpURI().getDecodedPath();
            if (!template.matches(path)) {
                return false;
            }
            Map params = template.getPathParams(path);
            System.out.println(params);
            Fields queryFields = Request.extractQueryParameters((Request)request);
            System.out.println(queryFields);
            response.setStatus(200);
            Content.Sink.write((Content.Sink)response, (boolean)true, (String)(params.toString() + "\n" + queryFields.toString()), (Callback)callback);
            return true;
        }
    }
}

