/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core;

import java.util.UUID;

public final class ActorId {
    private String type;
    private int actorGroup;
    private String id;

    public ActorId() {
    }

    public ActorId(String type, int actorGroup, String id) {
        this.type = type;
        this.actorGroup = actorGroup;
        this.id = id;
        if (id.contains("!") || id.contains("/") || id.contains("\\")) {
            throw new RuntimeException("Illegal character in id");
        }
    }

    public ActorId(String type, int actorGroup, Long id) {
        this.type = type;
        this.actorGroup = actorGroup;
        this.id = Long.toString(id);
    }

    public ActorId(String type, int actorGroup, UUID id) {
        this.type = type;
        this.actorGroup = actorGroup;
        this.id = id.toString();
    }

    public static ActorId create(String type, int actorGroup, String id) {
        return new ActorId(type, actorGroup, id);
    }

    public static ActorId create(Class<?> clazz, int actorGroup, String id) {
        return new ActorId(clazz.getName(), actorGroup, id);
    }

    public static ActorId createFromString(String actorIdString) {
        String[] s = actorIdString.split("!");
        int actorGroup = Integer.valueOf(s[1]);
        return new ActorId(s[0], actorGroup, s[2]);
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public int getActorGroup() {
        return this.actorGroup;
    }

    public int hashCode() {
        return (this.type + this.id).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActorId)) {
            return false;
        }
        ActorId other = (ActorId)obj;
        return this.type.equals(other.type) && this.id.equals(other.id) && this.actorGroup == other.actorGroup;
    }

    public String toString() {
        return this.type + "!" + this.actorGroup + "!" + this.id;
    }
}

