package net.sodacan.core.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Pool<T> {

    private final BlockingQueue<T> pool;

    public Pool(int maxSize, PoolItemFactory<T> factory) {
        this.pool = new LinkedBlockingQueue<>(maxSize);
        for (int i = 0; i < maxSize; i++) {
            try {
                pool.put(factory.createItem());
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public T acquireItem() throws InterruptedException {
        return pool.take();
    }

    public void returnItem(T obj) throws InterruptedException {
        pool.put(obj);
    }
}