package net.sodacan.core.util;

import net.sodacan.core.Config;
import net.sodacan.core.Jug;
import net.sodacan.core.Message;
import net.sodacan.core.Route;
import net.sodacan.core.Serializer;
import net.sodacan.core.jug.NormalMessage;

public class MessageUtils {
	/**
	 * <p>For testing only.
	 * <p>This is a quick and dirty way to inject a message into a running Host.
	 * It does not call any message life-cycle methods. It just gets the message into the queue.
	 * @param config
	 * @param message
	 */
	public static void submit(Config config, Message message ) {
		Route route = message.peekRoute();
		Serializer serializer = config.getSerializerFactory().create(route.getTarget());
		Jug jug = new NormalMessage(route.getTarget(),serializer.serialize(message));
		config.getHost().send(jug);
	}
}
