package net.sodacan.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Map;

import net.sodacan.core.Actor;
import net.sodacan.core.annotation.ActorType;

public class ClassUtilities {

	@SuppressWarnings("unchecked")
	private static Class<? extends Actor> getClass(String className, String packageName) {
        try {
            Class<? extends Actor> clazz = (Class<? extends Actor>) Class.forName(packageName + "." + className.substring(0, className.lastIndexOf('.')));
    		if (Actor.class.isAssignableFrom(clazz) 
    				&& !clazz.isInterface() 
    				&& !Modifier.isAbstract(clazz.getModifiers()) ) {
    			return (Class<? extends Actor>)clazz;
    		}
        } catch (ClassNotFoundException e) {
            // TODO: handle the exception
        }
        return null;
    }

	/**
	 * Find all classes in the named package that implement the Actor interface 
	 * and add them to our collection of
	 * known Actor classes.
	 * @param packageName
	 * @return
	 * @throws IOException 
	 */
	@SuppressWarnings("unchecked")
    public static Map<String, Class<? extends Actor>> getActorClassesFromPackage(String packageName, Map<String, Class<? extends Actor>> actorClasses ) throws Exception {
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while (true) {
        	String line = reader.readLine();
        	if (line==null) break;	// blank like means end of list
        	if (!line.endsWith(".class")) continue;
    		String className = packageName + "." + line.substring(0, line.lastIndexOf('.'));
            Class<?> clazz = Class.forName(className);
    		if (clazz==null) {
				System.out.println("Problem finding class: " + className);
				continue;
    		}
			// Make sure this class implements Actor interface
			boolean isActor = Actor.class.isAssignableFrom(clazz);
			Class<? extends Actor> actorClass = (Class<? extends Actor>) clazz;
			// And it may have an ActorType annotation
			Annotation ata = clazz.getAnnotation(ActorType.class);
			// If actor type annotation and Actor interface
			boolean isActorType = ata!=null && ata instanceof ActorType;
			if (!isActor && ! isActorType) continue;
			// Don't bother with abstract Actors
			boolean isAbstract = Modifier.isAbstract(actorClass.getModifiers());
			if (isActorType && isActor && !isAbstract) {
				String actorTypeName = ((ActorType) ata).name();
				if (actorTypeName==null) {
					actorTypeName = actorClass.getSimpleName();
				}
				if (actorClasses.containsKey(actorTypeName)) {
					throw new RuntimeException("Duplicate actorType: " + actorTypeName);
				}
				actorClasses.put(actorTypeName, actorClass);
				continue;
			}
			// An ActorType annotation on a non-Actor class is invalid
			if (!isActor && isActorType ) {
				throw new RuntimeException("@ActorType not allowed on: " + clazz.getName() );				
			}
        }
		System.out.println(actorClasses);
        return actorClasses;
    }
}
