package net.sodacan.core.serialize.gson;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

public class MapAdapter implements JsonSerializer<Map<String,Object>>, JsonDeserializer<Map<String,Object>> {

	@Override
	public JsonElement serialize(Map<String, Object> src, Type typeOfSrc, JsonSerializationContext context) {
		JsonArray array = new JsonArray();	
		 for (Entry<String,Object> e : src.entrySet()) {
			JsonObject top = new JsonObject();
	        top.addProperty("key", e.getKey());
	        top.add("value", context.serialize(e.getValue(), e.getValue().getClass()));
	        top.addProperty("type", e.getValue().getClass().getName());
	        array.add(top);
		}
		return array;
	}

	@Override
	public Map<String, Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
		JsonArray root = json.getAsJsonArray();
		Map<String, Object> map = new HashMap<>();
		for (int x=0;x<root.size();x++) {
			JsonObject entry = root.get(x).getAsJsonObject();
//				JsonObject entry = root.get("route").getAsJsonObject();
			JsonElement key = entry.get("key");
			JsonElement value = entry.get("value");
			JsonElement type = entry.get("type");
			try {
				Class<?> clazz = this.getClass().forName(type.getAsString());
				map.put(key.getAsString(), context.deserialize(value, clazz));
			} catch (Exception e) {
				throw new RuntimeException("Error deserializing payload",e);
			}
		}
		return map;
	}

}
