package net.sodacan.core.serialize.gson;

import java.lang.reflect.Type;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

import net.sodacan.core.ActorId;

public class ActorIdAdapter implements JsonSerializer<ActorId>, JsonDeserializer<ActorId> {

	@Override
	public ActorId deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
		return ActorId.createFromString(json.getAsString());
	}

	@Override
	public JsonElement serialize(ActorId src, Type typeOfSrc, JsonSerializationContext context) {
		return new JsonPrimitive(src.toString());
	}
}

