package net.sodacan.core.serialize;

import net.sodacan.core.ActorId;
import net.sodacan.core.Serializer;

/**
 * <p>A serializer Factory is created during configuration. The factory can then decide how it wants to organize access to shared resources, if any.
 * For example, some serializers might have slow startup times which means the factory might want to do the startup work once and
 * then hand out individual serializers that use the shared configuration.</p>
 * <p>In Sodacan, each individual Actor will have its own Serializer instance. The implementation can choose how to pool and/or share expensive resources, if any,
 * but it will need to consider concurrency issues if it does share such resources. Also note that Serializers will come and go quickly as Actor instances are created and destroyed.
 * Therefore, resources that are expensive to create that are shareable should be kept in the factory rather than in the individual instances.</p>
 */
public interface SerializerFactory {
	public Serializer create(ActorId actorId);

}
