/**
 * <p>The Scheduler for an ActorGroup is concerned with thread coordination.
 * It provides backpressure when the total number of in-flight messages exceeds
 * a threshold. It manages a thread pool, a limited resource, in which to run 
 * actors as messages arrive.
 *</p>
 *<p>The Scheduler is also where messages are serialized on a per-actor basis. When
 * an Actor is actually processing inbound messages a "fairness count" prevents the Actor
 * from effectively blocking other Actors from processing messages if the system gets busy or there are fewer threads available. 
 * The larger the fairness number, the faster an Actor can process messages. 
 * A smaller fairness number makes actors 
 * more responsive. The more physical threads
 * that are available, the more parallelism is possible and the less important fairness is.
 * Sodacan is designed to scale linearly with more threads because it keeps its dependency on 
 * thread synchronization to a minimum (and never exposes the need for synchronization to the Application Developer).
 * Sodacan is specifically designed to work well on systems with a large number of CPU cores.
 * </p>
 * <p>Most actors should avoid waiting for a resource to become available where possible.
 * Doing so will tie up a thread. Of course when doing so is the purpose of a particular Actor,
 * then waiting is the right thing to do as long as the Actor designer understands that the Actor
 * will not process any more messages until the previous message completes. 
 * </p>
 * <p>This scheduler avoids the need to use virtual threads. The only threads running 
 * are those Actors actively processing messages.</p>
 */
package net.sodacan.core.scheduler;