package net.sodacan.core.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

import net.sodacan.core.ActorGroup;

/**
 * Hold live statistics for an actor group
 */
public class Statistics {
	int actorGroupNumber;
	AtomicInteger messageCount = new AtomicInteger(0);
	AtomicInteger messageLoad = new AtomicInteger(0);
	AtomicInteger maxMessageLoad = new AtomicInteger(0);
	AtomicInteger evictionCount = new AtomicInteger(0);
	AtomicInteger totalSleepTime = new AtomicInteger(0);
	AtomicInteger maxThreadQueueDepth = new AtomicInteger(0);
	public int getActorGroupNumber() {
		return actorGroupNumber;
	}
	AtomicBoolean running = new AtomicBoolean(false);
	AtomicBoolean closing = new AtomicBoolean(false);
	AtomicInteger totalActorsCreated = new AtomicInteger(0);

	public Statistics( ActorGroup actorGroup) {
		this.actorGroupNumber = actorGroup.getActorGroupNumber();
	}
	
	public Integer getMessageCount() {
		return messageCount.get();
	}
	public Integer getMessageLoad() {
		return messageLoad.get();
	}
	public Integer getMaxMessageLoad() {
		return maxMessageLoad.get();
	}
	public Integer getEvictionCount() {
		return evictionCount.get();
	}
	public Integer getTotalSleepTime() {
		return totalSleepTime.get();
	}
	public Integer getMaxThreadQueueDepth() {
		return maxThreadQueueDepth.get();
	}
	public Boolean getRunning() {
		return running.get();
	}
	public Boolean getClosing() {
		return closing.get();
	}
	public Integer getTotalActorsCreated() {
		return totalActorsCreated.get();
	}

}
