package net.sodacan.core.persist.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

import net.sodacan.core.Actor;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.persist.AbstractPersister;

public class FilePersister extends AbstractPersister {
	File file;
	public FilePersister(Config config, ActorId actorId) {
		super(config, actorId);
		this.file = makeFile(".dat");
	}

	@Override
	public void begin() {
	}

	@Override
	public void commit() {
	}

	@Override
	public void rollback() {
	}

	@Override
	public void write(String key, byte[] bytes) {
		try {
			Files.write(file.toPath(), bytes);
		} catch (IOException e) {
			throw new RuntimeException("Error writing to file: " + file.getAbsolutePath(), e);
		}
	}

	@Override
	public byte[] read(String key) {
		try {
			if (file.exists()) {
				return Files.readAllBytes(file.toPath());
			} else return null;
		} catch (IOException e) {
			throw new RuntimeException("Error reading from file: " + file.getAbsolutePath(), e);
		}
	}

}
