package net.sodacan.core.persist;

import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Persister;

/**
 * <p>A persister Factory is created during configuration. The factory can then decide how it wants to organize access to shared resources, if any.
 * For example, some persisters might have slow startup times which means the factory might want to establish the startup work once with a pool of persisters 
 * and then hand out individual persisters that use the shared configuration.</p>
 * <p>In Sodacan, each individual Actor has its own Persister. The implementation can choose how to pool and/or share expensive resources
 * but it will need to consider concurrency issues if it does share such resources. 
 * Also note that Persisters will come and go quickly as Actor instances are created and destroyed.
 * Therefore, resources that are expensive to create that are shareable should be kept in the factory rather than in the individual instances.</p>
 */
public interface PersisterFactory {
	public Persister create(ActorId actorId);
}
