/**
 * <p>Sodacan is a distributed OLTP framework. 
 * </p>
 * <h2>Imagine</h2>
 * <p>The year is 2030. CPU technology has advanced to the point where machines have GPUs with thousands or cores, 
 * there are also main CPUs with thousands of cores. How would you take advantage of that number of CPUs? You could just divide up work with thousands of 
 * threads all stepping on each other trying to access common resources. Concurrent locks and barriers would number in the millions.
 * So, it's time to regroup. Here we exploit the Actor Model. (look it up or just read on).</p>
 * <p>An idealized actor could exist on its own little "island" including a processor, an operating system, its own disk storage, and a network connection. 
 * It would have a unique "address" such as a URL. It would have an "inbox" that other actors could send messages to. Our actor 
 * would process messages, one-at-a-time. The actor would also have an "outbox" which would then send messages on to other actors. Each of these actor-machines 
 * would be independent of the others. Thousands, or even millions of these Actors all humming away without concern about concurrency. Think of this as the ultimate 
 * in a scaleable design.
 * </p>
 * <p>Now, you might be thinking that it could be problematic if each of these millions of actors needed to establish a connection to a database. 
 * And you would be correct. So, Sodacan doesn't do it that way. The Actor model combines data and behavior together on each of these Actor islands.</p>
 * <p>Actors in Sodacan include "big" actors such as an employee list. And, 
 * small actors such as an individual employee. Or, a controller for an IOT device. An actor can even be tiny and short lived such as a single HTTP request.
 * </p>
 * <p>And now back to reality. It's not 2030 yet, but the march is on. Sodacan takes a measured approach to future technology. Without getting into details, a simple 
 * configuration setting will control how many actors run on a particular island. Another configuration setting determines how many replicas of an Actor need 
 * to be maintained to make the system durable and available.
 * So, as the compute environment progresses, Actors do not need to change, only configuration, because they are already designed and implemented at the smallest practical granularity.</p>
 * <h2>Assumptions</h2>
 * <p>The following is a summary of assumptions about the Sodacan framework. They are explained in more detail elsewhere:
 * </p>
 * <ul>
 * <li>In Sodacan, Actors really are isolated from other Actors. No locking and blocking needed.</li>
 * <li>Each actor has its own private storage, if it needs storage. Sodcan handles persistence of this data transparently and reliably.</li>
 * <li>An Actor can and often does move around in a cluster. The movement of an actor, including its persistent data, is handled by Sodacan.
 * </li>
 * <li>Messages are the only way Actors can talk to each other. Sodacan facilitates the full lifecycle of messages including keeping 
 * track of where in the cluster a particular Actor is active.</li>
 * <li>Sodacan maintains replicas of Actors for hot, warm, and cold backups.</li>
 * <li>Sodacan is a peer-to-peer network. No broker-intermediary between Sodacan Hosts.</li>
 * </ul>
 * <h2>Actor Rules</h2>
 * <p>Viewed from the outside, an actor can send and receive messages and an actor has persistent state. That's it. </p>
 * <blockquote>You might be wondering why "create new actors" is not part of these capabilities. That is because, in Sodacan, 
 * the way an Actor gets created is by sending a message to it. Sodacan does not require an Actor to be owned by another Actor. 
 * Ownership, as needed, is an application level decision. So, for an 
 * Actor to create a new Actor instance, of any kind, it generates a new ActorId and sends a message to that new Actor.
 * </blockquote>
 * <p>All actors are single threaded. Sodacan has a few rules about being a well-behaved Actor: It's best not to sleep within an Actor. See Timer actor.
 * Also, you'll find that using asynchronous processing within an Actor can be problematic. If an actor wants to hold a connection or other resource open 
 * between messages, then that actor will not be able to migrate when needed for load balancing and failover.
 * If an actor does need to access external resources, such as an http server, Sodacan has a variation of a normal Actor called a 
 * HostBound Actor for that sort of thing.</p>
 * <p>If an actor throws an exception, it will be caught within that actor so that other
 * actors are unaffected and subsequent messages can be processed.
 * In other respects, Actors are nothing more than application code.</p>
 * <h2>Attributes of an Actor</h2>
 * <p>Regardless of how many replicas of a specific Actor (ActorId) only one replica is ever active at the same time. 
 * In Sodacan, scale is achieved by using fine-grained actors. Not by having multiple copies of the 
 * same actor instance operating in parallel. It is Sodacan's job to get a message from a source Actor to
 * a destination Actor no matter where it is located.</p>
 * <p>In many application environments, time-consuming actions such as network, database and file IO are often performed asynchronously. 
 * Sodacan takes the opposite approach. Since Actors have already decomposed an application into probably 
 * the smallest possible elements, Sodacan attempts to pile everything possible into the Actor's thread of execution. This 
 * is not a limitation of Sodacan; Actors are free to spawn more threads as they see fit. Rather, this is a design choice: To keep 
 * any given Actor instance as single-threaded and therefore as simple and scalable as possible: Less contention over shared resources
 * means the more linear a system can scale.</p>
 * <p>An actor has its own state. 
 * In other words, the logic that protects and uses data is kept together with the data in an Actor. 
 * Sodacan, by its nature, doesn't need a database though you are not prevented from using one.
 * </p>
 * 
 * <p>Some Actors will behave as a Finite State Machine. This is handled easily by the Actor itself. Note: The pure definition of Actor Model actors 
 * says that when an Actor processes a message, it determines the behavior applied to the next message received. Sodacan doesn't intrinsically 
 * support this type of behavior although it is easy to emulate it using state Transactions.</p>
 * <h2>Sodacan ActorGroup</h2>
 * <p>An Actor has a permanent ActorId, unique in the Sodacan network. 
 * The assignment is usually
 * random, but permanent, unique and usually meaningless. Actors are also permanently assigned to a partition called an ActorGroup. ActorGroups 
 * are usually replicated across a network of Hosts, one Host per node. 
 * As an ActorGroup goes, so goes its Actors. If an ActorGroup needs to move, all Actors in that 
 * group will move together.
 * </p>
 * <h2>Sodacan Host</h2>
 * <p>A Sodacan Host temporarily hosts one or more 
 * ActorGroups. ActorGroups can (and should) be replicated for durability.
 * The configuration can specify the number of ActorGroup replicas to maintain including what it takes to maintain a quorum.
 * </p>
 * <h2>Sodacan Coordinator</h2>
 * <p>Sodacan is a peer-to-peer network. No single point of failure. It is common to operate at least two hot replicas for
 * any given ActorGroup. Additional "cold" replicas can also be configured. 
 * Cold replicas require less compute but take longer to come on-line. 
 * Having only a single copy of any particular ActorGroup is not durable or fault-tolerant. 
 * A minimum of three ActorGroup replicas, each on a different Host, are required for durability. But the number 
 * can be much higher as needed for horizontal scaling.
 * </p>
 * <h2>Sodacan Supports Business Processes</h2>
 * <p>
 * From a design perspective, actors provide a way to represent steps in a business process without having to worry about 
 * data persistence: If an Actor "owns" some data, that data stays with the Actor. Sodacan supports "foreign data" as well: 
 * An Actor can maintain a copy of data that is owned by another Actor. Any updates to the owning Actor's data arrives in a message. 
 * The foreign data can arrive 
 * before a business event message or after. It can't arrive during an event. 
 * However, it can arrive "with" the business event.
 * For example, a message starting out with just a customer id in its payload could be routed through the customer 
 * Actor to pick up a subset of customer data
 * needed to complete the transaction in the target Actor.
 * When the message arrives at, for example, a shopping-cart
 * actor, the customer information is available in the payload. In Sodacan, this is called message routing which allows a single 
 * message to represent a business transaction with several steps. 
 * In addition to simple point-to-point messages, it is also common for messages that represent a business processes 
 * to fan-out and fan-in to easily allow parallel processing. 
 * In a shopping-cart example, a message would fan-out to all of the product actors for a 
 * price quote and then fan back in to complete the flow.
 * </p>
 * <p>Each Sodacan Actor has a stage which holds zero or more outbound messages. The Stage, and hence its name, holds 
 * all external effects from processing 
 * one inbound message. This includes the Actor's persistent data.
 * The Actor's Stage is what supports transaction semantics.
 * The messages in the stage will be sent upon a commit within the Actor, or rolled back as needed. 
 * </p>
 * <h2>InterHost communication</h2>
 * <p>A Sender is a delegate of a Host tasked with sending messages to other hosts.
 * When a message must be sent from one host to another, the Sender facilitates the movement. A Sender
 * does not operate directly between Actors but rather between Hosts. The message flow is as follows:
 * </p>
 * <ul>
 * <li>The source actor prepares one or more messages to be sent. It does this by serializing the message into
 * a byte array with the Actor id of the destination in plain text. This is held in a Jug.</li>
 * <li>A Jug is given to the ActorGroup containing that actor. Control is still 
 * in the source Actor's thread.</li>
 * <li>The ActorGroup then hands the Jug(s) off to the Host containing the ActorGroup.</li>
 * <li>The Host, while still in the Actor's thread, makes a quick routing decision. The Host decides if the Jug is to stay local, 
 * in which case, the Jug is added to the target (including the same) ActorGroup's Jug Queue.
 * Thus ends the source Actor's thread involvement in the process.</li>
 * <li>If the Host decides the Jug must go to another Host, either because the target actor is running on another Host
 * or because the local Jug must be replicated to another Host, it will be queued, perhaps more than once, to the
 * hosts Sender. As with local Jugs, at this point, control returns to the Actor where the Actor will likely go on to 
 * process the next inbound message (Jug).</li>
 * </ul>
 * <p>A Sender could be implemented by an HTTP client although a simple Netty client is sufficient.</p>
 * <p>On the other end is a Receiver. A Receiver can be implemented as an HTTP server. However, a Netty server is sufficient
 * because it does not need to spawn a thread to handle the request. Rather, the message is immediately queued for processing within Sodacan.
 * A Receiver is a delegate of a 
 * host and is responsible for  accepting inbound messages addressed to this host. The receiver dispatches Jugs received to the 
 * inbound queue of the appropriate actor group. Implementation Note: Because the path from a received Jug to the target 
 * ActorGroup is very short and fast, the server need not bother creating threads to process requests. 
 * Details of the steps at this point are:</p>
 * <ul>
 * <li>Upon receiving an inbound Jug, the Jug is added to the inbound queue of the target ActorGroup. 
 * (The ActorGroup will then distribute the Jug to the appropriate 
 * Actor's inbound queue.)</li>
 * <li>The Receiver can immediately return to listening for the next request. If an HTTP server is used then a response is returned saying, 
 * in effect, Jug received and queued.</li>
 * <li>The Receiver must determine which ActorGroup to queue the Jug. Once this is done, the Receiver's job is done. The Receiver does not maintain any Jug state.</li>
 * <li>The Jug is then further dispatched into the Actor's queue. The ActorGroup then returns to process more Jugs from its queue.</li>
 * <li>An internal ActorEntry, on behalf of the Actor, processes inbound Jugs. In a thread allocated to the Actor,
 * a Jug is removed from the queue, deserialized into a Message, and the Actor's "processMessage" method is called, thus concluding the Jug's journey.</li>
 * </ul>

 * <h2>Package Contents</h2>
 * <p>This package contains all of the important interfaces used in Sodacan.
 * Each of the packages below this package contain the implementation classes and a more detailed description of the capabilities provided by that package.
 * </p>
 * @author John Churin
 */
package net.sodacan.core;
