package net.sodacan.core.message;

import java.time.Instant;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

import net.sodacan.core.Config;

//import com.fasterxml.uuid.Generators;
//import com.fasterxml.uuid.impl.UUIDUtil;

import net.sodacan.core.MessageId;

public class DefaultMessageId implements MessageId, Comparable<MessageId> {
	protected Instant timestamp;
	protected int unique;
	
	public DefaultMessageId() {
		timestamp = null;
		unique = 0;
	}

	public DefaultMessageId(Instant timestamp, int unique) {
		this.timestamp = timestamp;
		this.unique = unique;
	}

	public DefaultMessageId(Config config) {
//		uuid = Generators.timeBasedReorderedGenerator().generate();
		this.timestamp = config.getClock().instant();
		this.unique = Math.abs(config.getRandom().nextInt());
	}
	
	@Override
	public Instant getTimestamp() {
		return timestamp;
	}

	@Override
	public int getUnique() {
		return unique;
	}

	@Override
	public String toString() {
		if (timestamp!=null) {
			return timestamp.toString() + "-" + unique;
		} else {
			return "No timestamp";
		}
	}

	@Override
	public int hashCode() {
		return timestamp.hashCode()<<1 + unique<<2;
	}

	@Override
	public boolean equals( Object other) {
		if (other instanceof DefaultMessageId dmi) {
			return (timestamp.equals(dmi.timestamp)
					&& unique == dmi.unique);
		} else return false;
	}

	@Override
	public int compareTo(MessageId o) {
		int r = this.timestamp.compareTo(o.getTimestamp());
		if (r!=0) return r;
		return Integer.compare(unique, o.getUnique());
	}

}
