package net.sodacan.core.jug;

import net.sodacan.core.ActorId;
import net.sodacan.core.Jug;
/**
 * The carrier for messages sent between Actors.
 */
public class NormalMessage implements Jug {
	private final ActorId actorId;
	private final byte[] message;

	public NormalMessage(ActorId actorId, byte[] message) {
		super();
		this.actorId = actorId;
		this.message = message;
	}
	
	public ActorId getActorId() {
		return actorId;
	}
	
	public byte[] getMessage() {
		return message;
	}
	
	@Override
	public String toString() {
		return "Jug: " + actorId;
	}
}
