package net.sodacan.core.journal;
/**
 * <p>The first 2^16 bytes of a journal file are reserved for header information pertaining to the format of the rest of the file.
 * Each entry in a journal has a permanent, monotonic, non-contiguous identifier. For efficiency, the identifier corresponds to, 
 * but is not the same as, the offset of the entry within the file. </p>
 */
public class JournalHeader {
	private long initialOffset = -1; // Offset of this entry
	private int version = 0;
	private int journalEntryLength = 0;

}
