package net.sodacan.core.host;

import net.sodacan.core.Config;
import net.sodacan.core.Host;
import net.sodacan.core.coordinator.HostEntry;
import net.sodacan.core.coordinator.HostEntry.Mode;
/**
 * In a default host, all actorGroups are contained within the (single) host
 */
public class DefaultHost extends AbstractHost implements Host {

	public DefaultHost(Config config) {
		super(config);
	}

	/**
	 * <p>Get things started in a host. </p>
	 * <ul>
	 * <li>Create Coordinator</li>
	 * <li>Create actorGroups</li>
	 * <li>Set initialized to true</li>
	 * </ul>
	 */
	@Override
	public void initialize() {
		if (isInitialized()) return;
		// Add an actor group for our HostBound ActorGroup
		activeActorGroups.put(new HostEntry(getHostNumber(), 
				-getConfig().getHostNumber(), Mode.Host), 
				getConfig().createActorGroup(-getConfig().getHostNumber()));
		// And then the rest
		for (int ag=1;ag<getConfig().getActorGroups()+1;ag++) {
			activeActorGroups.put(new HostEntry(getHostNumber(), ag, Mode.Live), getConfig().createActorGroup(ag));
		}
		setInitialized(true);
	}

	@Override
	public void start() {
		initialize();
	}

	@Override
	public String toString() {
		return "DefaultHost: " + getHostNumber();
	}

}
