package net.sodacan.core.coordinator;

import java.util.ArrayList;
import java.util.List;

import net.sodacan.core.Config;
import net.sodacan.core.Coordinator;
import net.sodacan.core.coordinator.HostEntry.Mode;

/**
 * <p>For this Single host coordinator, the static configuration is provided and used. Only a single Host is provided
 * and that host hosts all possible actorGroups.
 * An existing single-host setup can be upgraded to a cluster configuration when the time comes
 * without affecting how Actors are implemented.
 * </p>
 */
public class SingleHostCoordinator extends AbstractCoordinator implements Coordinator {

	public SingleHostCoordinator(Config config) {
		super(config);
	}

	
	@Override
	public String toString() {
		return getClass().getSimpleName();
	}

	/**
	 * <p>A simple one host coordinator. The host number is taken from the configuration.
	 * And the groups are numbered from 1 to config.actorGroups+1. All groups are Live on this one host.
	 * This list controls the lifecycle of the ActorGroups on this host.</p>
	 */
	@Override
	public List<HostEntry> getActorGroupsForHost() {
		List<HostEntry> entries = new ArrayList<>(config.getActorGroups()+1);
		for (int x=1;x<config.getActorGroups()+1;x++) {
			entries.add(new HostEntry(config.getHostNumber(),x,Mode.Live));
		}
		return entries;
	}
	
	/**
	 * <p>This returns the hosts, including the current host, as to where 
	 * messages should be sent.</p>
	 * @return
	 */
	@Override
	public List<Integer> getHostsForActorGroup(int agNumber) {
		List<Integer> entries = new ArrayList<>(1);
		entries.add(config.getHostNumber());
		return entries;
	}
	
	@Override
	public int getLiveHostForActorGroup(int agNumber) {
		return config.getHostNumber();
	}

}
