package net.sodacan.core.coordinator;
/**
 * <p>Contains a combination of host number, actorgroup number, and actorGroup state. The coordinator
 * sends this information to a host to indicate how the host should be configured.</p>
 * <p>In a single=host configuration, the host gets one entry from the coordinator: Host #1, ActorGroup #1, State=live.</p>
 * <p>Note: Host number is configured at startup per instance and is used to fetch the intended ActorGroups for that one host.
 * </p>
 *
 */
public final class HostEntry {
	/**
	 * <ul>
	 * <li>Active state means that this actorGroup is able to process messages.</li>
	 * <li>Replica state means that this actorGroup is only receiving actor state messages
	 * and storing them locally in anticipation of possibly becoming active.</li>
	 * <li>The Host mode allows the specified ActorGroup to remain bound to the host; It can't move
	 * like an ordinary ActorrGroup.</li>
	 * </ul>
	 */
	public enum Mode {Live, Hot, Warm, Cold, OffLine, Host};
	private int host;
	private int actorGroup;
	private Mode mode;
	
	public HostEntry(int host, int actorGroup, Mode mode) {
		super();
		this.host = host;
		this.actorGroup = actorGroup;
		this.mode = mode;
	}
	
	public int getHost() {
		return host;
	}
	
	public int getActorGroup() {
		return actorGroup;
	}
	
	public Mode getMode() {
		return mode;
	}

	@Override
	public int hashCode() {
		Integer x = host+actorGroup;
		return x.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof HostEntry he) {
			return (host==he.host
			&& actorGroup==he.actorGroup
			&& mode==he.mode ); 
		}
		return false;
	}

	@Override
	public String toString() {
		return "Host=" + host + " actorGroup=" + actorGroup + " mode=" + mode;
	}	
}
