package net.sodacan.core.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import net.sodacan.core.Actor;
import net.sodacan.core.annotation.Save;

/**
 * Actor Metadata is gathered during configuration so that can be static while the system is Active. One instance per registered Actor.
 */
public class ActorMetadata {
	protected Class<? extends Actor> actorClass;
	protected Map<String,Field> saveFields = null;
	protected Set<Class<?>> generics = new TreeSet<>(Comparator.comparing(Class::getName));
	
	public ActorMetadata(Class<? extends Actor> actorClass) {
		this.actorClass = actorClass;
		loadFieldMetadata();
	}

	public Map<String, Field> getSaveFields() {
		return saveFields;
	}

	/**
	 * Called from constructor
	 */
	protected void loadFieldMetadata() {
		saveFields = new HashMap<>();
		Field[] fields = actorClass.getDeclaredFields();
		for (Field field : fields) {
			Save save = field.getAnnotation(Save.class);
			// We only care about annotated fields
			if (save==null) continue;
			if (save.name()==null || save.name().isBlank()) {
				throw new RuntimeException("Missing @Save name");
			}
			// Verify that this allows public access (needed for restore)
			int modifiers = field.getModifiers();
			if (!Modifier.isPublic(modifiers)) {
				throw new RuntimeException("Field " + field.getName()+  " in " + actorClass.getSimpleName() + " must be public");				
			}
			if (save!=null) {
				generics.add(field.getType());
				saveFields.put(save.name(), field);
//			    Class<?> generic = (Class<?>) ((ParameterizedType) field.getGenericType()).getActualTypeArguments()[0];
			}
		}
	}


}
