package net.sodacan.core.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
/**
 * <p>The ActorType annotation is optional on an ActorClass but strongly advised.
 * All actor ids contain the type of actor and a unique identifier. If the
 * type of the actor is not defined, then the actorId is defaulted to the full name of
 * the actor class. This causes several problems: </p>
 * <ul>
 * <li>The full class name can be long. </li>
 * <li>The class name could be refactored causing any messages addressing that actor to become lost.</li>
 * <li>The class name would be meaningless to a non-jvm entity.</li>
 * </ul>
 * <p>The annotation is not strictly required. ActorTypes can also be registered explicitly 
 * in the configuration.</p>
 */
@Target(ElementType.TYPE)
@Inherited
@Retention(RetentionPolicy.RUNTIME)
public @interface ActorType {
	String name();
}
