package net.sodacan.core.actorgroup;

import java.util.Random;

import net.sodacan.core.ActorGroupAssigner;
import net.sodacan.core.Config;

public class RandomActorGroupAssigner extends AbstractActorGroupAssigner implements ActorGroupAssigner {
	Random random = new Random();
	
	public RandomActorGroupAssigner(Config config) {
		super(config);
	}

	@Override
	public String toString() {
		return getClass().getSimpleName();
	}

	/**
	 * Assign an actor group randomly. However, if the actorType name begins with
	 * a dollar sign, the HostBound actorGroup number is returned.
	 */
	@Override
	public int assign(String actorType, String id) {
		if (actorType.startsWith("$")) {
			return -getConfig().getHostNumber();
		}
		if (maxActorGroups==1) return 1;
		return random.nextInt(1, maxActorGroups);
	}

}
