package net.sodacan.core.actor;

import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
/**
 * <p>A WorkerActor has no state, it's ephemeral. As such, this kind of actor is more lightweight than many other kinds of actors.
 * A WorkerActor is appropriate to use when parallelism is more important than 
 * serialization of messages.</p>
 * <p>A worker actor usually has a lifecycle of just one message. A WorkerActor usually appears in the same ActorGroup of the Actor
 * that will receive the reply message it will send at the conclusion of the sleep.</p>
 * <p>Say an Actor needs to be awakened after a few seconds because it is waiting for another message to arrive. Putting a sleep into
 * the Actor would prevent it from receiving any other messages. To solve this problem, the Actor can send a Message to
 *  a Sleeper actor, a kind of WorkerActor,
 * that will send a message back to our actor after a delay.</p>
 */
public abstract class WorkerActor extends AbstractActor {

	public WorkerActor(Config config, ActorId actorId) {
		super(config, actorId);
		// TODO Auto-generated constructor stub
	}

}
