package net.sodacan.core.actor;

import java.util.UUID;

import net.sodacan.core.ActorId;
import net.sodacan.core.ActorIdFactory;
import net.sodacan.core.Config;

public class UUIDActorIdFactory implements ActorIdFactory {
	Config config;
	public UUIDActorIdFactory(Config config) {
		this.config = config;
	}
	
	public ActorId create(String actorType) {
		if (config.getActorClass(actorType)==null) {
			throw new RuntimeException("Invalid ActorType: " + actorType);
		}
		String id = UUID.randomUUID().toString();
		int actorGroup = config.getActorGroupAssigner().assign(actorType, id);
		// Override id field if it's a HostBoound Actor.
		if (actorGroup<0) {
			id = "host";
		}
		return new ActorId(actorType,actorGroup,id);
	}

}
