package net.sodacan.core.actor;

import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
/**
 * <p>This timer actor provides a simple but important service for other Actors:
 * It will accept a message, hold on to the message for a specified amount
 * of time and then forward that message to its next step which could be
 * the Actor that sent the message or any other actor.
 * </p>
 * <p>This Actor can withstand a Host restart and will send messages it might have missed during
 * any down time.</p>
 * <p>This actor is specified as a HostBound Actor. For this purpose, its lifecycle is different
 * from normal Actors: Normal Actors can come and go at the whim Sodacan. That wouldn't work 
 * this kind of actor. So, this and other HostBound Actors 
 * stay put; They control their own lifecycle. 
 * </p>
 */
public class TimeActor extends AbstractActor {

	public TimeActor(Config config, ActorId actorId) {
		super(config, actorId);
		// TODO Auto-generated constructor stub
	}

}
