package net.sodacan.core;

/**
 * A message route carries the information needed to get a message to where 
 * it is going and what it's purpose is when it gets there.
 * Routes in a message are organized into a stack to facilitate complex
 * message flows. The top of the stack describes where the message is currently heading.
 * The bottom of the stack is often the Actor that initiated the message in the first place or perhaps
 * a different reply-to Actor.
 */
public class Route {
	private ActorId target = null;
	private Verb verb = null;
	
	public Route() {
	}

	public ActorId getTarget() {
		return target;
	}

	public Verb getVerb() {
		return verb;
	}

	
	public void setTarget(ActorId target) {
		this.target = target;
	}

	public void setVerb(Verb verb) {
		this.verb = verb;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(target);
		sb.append(": ");
		sb.append(verb);
		return sb.toString();
	}		
}
