package net.sodacan.core;
/**
 * <p>A normal Jug contains an ActorId and a ByteArray of a Sodacan Message. It is used extensively between Actors.
 * Behind the scenes, an Actor receives a Jug which is placed on the Actor's queue. When the Actor pulls the next Jug from the queue, 
 * it is deserialized into a full Message which is passed to the processMessage method of the Actor. From this point on, the application 
 * developer only has to deal with a Message. When the Actor sends a message outbound, a new Jug is created to contain the serialized message
 * which is then sent on its way to the specified target ActorId.</p>
 * <p>A Jug is kept simple; It has no behavior. Any encoding, format, or encryption information is contained within the byte array and is dealt 
 * with during deserialization. The ActorId itself must be serialized for most methods of transmission. It is serialized/deserialized as a simple string
 * separately by methods within the ActorId class. A Jug is immutable after creation.</p>
 * <p>Why the name Jug? In mythical times, a bottle or jar with a message inside was thrown into the sea, destination unknown. 
 * The word bottle is too overloaded and the word jar has a different meaning in the Java world.
 * So, jug, a synonym, it is! Jug is also a nod to my deceased father, George, who started his programming career in the 1940s. 
 * The name Jug came from my aunt Edna: When she was young she couldn't pronounce her older brothers name George. It came out Jug and the name stuck.
 * </p>
 */
public interface Jug {
}
